/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.ads;

import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.PartialTransitionAnalyzer;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.ads.ADSUtil;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefensiveADS<S, I, O> {
    private final MealyMachine<S, I, ?, O> automaton;
    private final Alphabet<I> alphabet;
    private final Set<S> states;
    private final PartialTransitionAnalyzer<S, I> partialTransitionAnalyzer;
    private @Nullable Set<S> refinementStates;
    private @Nullable I refinementInput;

    private DefensiveADS(MealyMachine<S, I, ?, O> automaton, Alphabet<I> alphabet, Set<S> states, PartialTransitionAnalyzer<S, I> partialTransitionAnalyzer) {
        this.automaton = automaton;
        this.alphabet = alphabet;
        this.states = states;
        this.partialTransitionAnalyzer = partialTransitionAnalyzer;
    }

    public static <S, I, O> Optional<ADTNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> alphabet, Set<S> states, PartialTransitionAnalyzer<S, I> pta) {
        return super.compute();
    }

    private Optional<ADTNode<S, I, O>> compute() {
        ReflexiveMapView<S> initialMapping = new ReflexiveMapView<S>(this.states);
        Optional<ADTNode<S, I, O>> interMediateResult = this.compute(initialMapping);
        while (!interMediateResult.isPresent() && this.refinementStates != null && this.refinementInput != null) {
            for (S s2 : this.refinementStates) {
                this.partialTransitionAnalyzer.closeTransition(s2, this.refinementInput);
            }
            this.refinementStates = null;
            this.refinementInput = null;
            interMediateResult = this.compute(initialMapping);
        }
        return interMediateResult;
    }

    private Optional<ADTNode<S, I, O>> compute(Map<S, S> mapping) {
        long maximumSplittingWordLength = ADSUtil.computeMaximumSplittingWordLength(this.automaton.size(), mapping.size(), this.states.size());
        LinkedList splittingWordCandidates = new LinkedList();
        StateIDs<Object> stateIds = this.automaton.stateIDs();
        HashSet<BitSet> cache = new HashSet<BitSet>();
        splittingWordCandidates.add(Word.epsilon());
        while (!splittingWordCandidates.isEmpty()) {
            @NonNull Word prefix = (Word)splittingWordCandidates.poll();
            Map<Object, Object> currentToInitialMapping = mapping.keySet().stream().collect(Collectors.toMap(x -> this.automaton.getSuccessor(x, prefix), mapping::get));
            BitSet currentSetAsBitSet = new BitSet();
            for (Object s2 : currentToInitialMapping.keySet()) {
                currentSetAsBitSet.set(stateIds.getStateId(s2));
            }
            if (cache.contains(currentSetAsBitSet)) continue;
            block2: for (Object i : this.alphabet) {
                HashSet<S> statesWithMissingTransitions = new HashSet<S>();
                for (Object object : currentToInitialMapping.keySet()) {
                    if (this.partialTransitionAnalyzer.isTransitionDefined(object, i)) continue;
                    statesWithMissingTransitions.add(object);
                }
                if (!statesWithMissingTransitions.isEmpty()) {
                    if (this.refinementStates != null && statesWithMissingTransitions.size() >= this.refinementStates.size()) continue;
                    this.refinementStates = statesWithMissingTransitions;
                    this.refinementInput = i;
                    continue;
                }
                HashMap successors = new HashMap();
                for (Object entry : currentToInitialMapping.entrySet()) {
                    Object nextMapping;
                    Object object = entry.getKey();
                    Object nextState = this.automaton.getSuccessor(object, i);
                    Object nextOutput = this.automaton.getOutput(object, i);
                    if (!successors.containsKey(nextOutput)) {
                        nextMapping = new HashMap();
                        successors.put(nextOutput, nextMapping);
                    } else {
                        nextMapping = (Map)successors.get(nextOutput);
                    }
                    if (nextMapping.put(nextState, entry.getValue()) == null) continue;
                    continue block2;
                }
                if (successors.size() > 1) {
                    Object entry;
                    HashMap hashMap = new HashMap();
                    entry = successors.entrySet().iterator();
                    while (entry.hasNext()) {
                        Optional<ADTNode<S, I, O>> succ;
                        Map.Entry entry2 = (Map.Entry)entry.next();
                        Map currentMapping = (Map)entry2.getValue();
                        BitSet currentNodeAsBitSet = new BitSet();
                        for (Object s4 : currentMapping.keySet()) {
                            currentNodeAsBitSet.set(stateIds.getStateId(s4));
                        }
                        if (cache.contains(currentNodeAsBitSet)) continue block2;
                        if (currentMapping.size() > 1) {
                            succ = this.compute(currentMapping);
                        } else {
                            Object s2 = currentMapping.values().iterator().next();
                            succ = Optional.of(new ADTLeafNode(null, s2));
                        }
                        if (!succ.isPresent()) {
                            cache.add(currentNodeAsBitSet);
                            continue block2;
                        }
                        hashMap.put(entry2.getKey(), succ.get());
                    }
                    Pair<ADTNode<S, Object, O>, ADTNode<S, Object, O>> ads = ADTUtil.buildADSFromTrace(this.automaton, prefix.append(i), mapping.keySet().iterator().next());
                    ADTNode<S, Object, O> aDTNode = ads.getFirst();
                    ADTNode<S, Object, O> tail = ads.getSecond();
                    for (Map.Entry entry3 : hashMap.entrySet()) {
                        ((ADTNode)entry3.getValue()).setParent(tail);
                        tail.getChildren().put(entry3.getKey(), (ADTNode)entry3.getValue());
                    }
                    return Optional.of(aDTNode);
                }
                if ((long)prefix.length() >= maximumSplittingWordLength) continue;
                splittingWordCandidates.add(prefix.append(i));
            }
            cache.add(currentSetAsBitSet);
        }
        return Optional.empty();
    }
}

