/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.config.model.replacer;

import com.google.common.collect.Sets;
import de.learnlib.algorithm.adt.adt.ADT;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.SubtreeReplacer;
import de.learnlib.algorithm.adt.config.model.ADSCalculator;
import de.learnlib.algorithm.adt.model.ReplacementResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;

public class ExhaustiveReplacer
implements SubtreeReplacer {
    private final ADSCalculator adsCalculator;

    public ExhaustiveReplacer(ADSCalculator adsProvider) {
        this.adsCalculator = adsProvider;
    }

    @Override
    public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
        if (ADTUtil.collectResetNodes(adt.getRoot()).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet statesAsSet = new HashSet(hypothesis.getStates());
        Optional<ADTNode<S, I, O>> potentialResult = this.adsCalculator.compute(hypothesis, inputs, statesAsSet);
        if (potentialResult.isPresent()) {
            return Collections.singleton(new ReplacementResult<S, I, O>(adt.getRoot(), potentialResult.get()));
        }
        Set<ADTNode<S, I, O>> candidates = ADTUtil.collectADSNodes(adt.getRoot());
        candidates.remove(adt.getRoot());
        PriorityQueue<Set> queue = new PriorityQueue<Set>(candidates.size(), Comparator.comparingInt(Set::size));
        for (ADTNode<S, I, O> node : candidates) {
            Set<ADTNode<S, I, O>> leaves = ADTUtil.collectLeaves(node);
            HashSet set = Sets.newHashSetWithExpectedSize(leaves.size());
            for (ADTNode<S, I, O> l : leaves) {
                set.add(l.getHypothesisState());
            }
            queue.add(set);
        }
        while (!queue.isEmpty()) {
            Optional<ADTNode<S, I, O>> alt;
            Set finalNodes = (Set)queue.remove();
            HashSet targets = new HashSet(statesAsSet);
            targets.removeAll(finalNodes);
            if (targets.size() < 2 || !(alt = this.adsCalculator.compute(hypothesis, inputs, targets)).isPresent()) continue;
            return Collections.singleton(new ReplacementResult<S, I, O>(adt.getRoot(), alt.get(), finalNodes));
        }
        return Collections.emptySet();
    }
}

