/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.model;

import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.FastMealy;
import net.automatalib.automaton.transducer.FastMealyState;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.equivalence.NearLinearEquivalenceTest;
import net.automatalib.word.Word;

public class ObservationTree<S, I, O> {
    private final Alphabet<I> alphabet;
    private final FastMealy<I, O> observationTree;
    private final Map<S, FastMealyState<O>> nodeToObservationMap;

    public ObservationTree(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.observationTree = new FastMealy(alphabet);
        this.nodeToObservationMap = new HashMap<S, FastMealyState<O>>();
    }

    public FastMealy<I, O> getObservationTree() {
        return this.observationTree;
    }

    public void initialize(S state) {
        FastMealyState init = (FastMealyState)this.observationTree.addInitialState();
        this.nodeToObservationMap.put(state, init);
    }

    public void initialize(Collection<S> states, Function<S, Word<I>> asFunction, Function<Word<I>, Word<O>> outputFunction) {
        FastMealyState init = (FastMealyState)this.observationTree.addInitialState();
        for (S s2 : states) {
            Word<I> as = asFunction.apply(s2);
            FastMealyState<O> treeNode = this.addTrace(init, as, outputFunction.apply(as));
            this.nodeToObservationMap.put(s2, treeNode);
        }
    }

    public void addTrace(S state, Word<I> input, Word<O> output) {
        this.addTrace(this.nodeToObservationMap.get(state), input, output);
    }

    private FastMealyState<O> addTrace(FastMealyState<O> state, Word<I> input, Word<O> output) {
        assert (input.length() == output.length()) : "Traces differ in length";
        Iterator<I> inputIter = input.iterator();
        Iterator<O> outputIter = output.iterator();
        FastMealyState<O> iter = state;
        while (inputIter.hasNext()) {
            FastMealyState<O> nextState;
            I nextInput = inputIter.next();
            O nextOuput = outputIter.next();
            if (this.observationTree.getTransition(iter, nextInput) == null) {
                nextState = (FastMealyState<O>)this.observationTree.addState();
                this.observationTree.addTransition(iter, nextInput, nextState, nextOuput);
            } else {
                assert (Objects.equals(nextOuput, this.observationTree.getOutput(iter, nextInput))) : "Inconsistent observations";
                nextState = this.observationTree.getSuccessor(iter, nextInput);
            }
            iter = nextState;
        }
        return iter;
    }

    public void addTrace(S state, ADTNode<S, I, O> adtNode) {
        FastMealyState<O> internalState = this.nodeToObservationMap.get(state);
        ADTNode adsIter = adtNode;
        while (adsIter != null) {
            Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(adsIter);
            this.addTrace(internalState, trace.getFirst(), trace.getSecond());
            adsIter = (ADTNode)ADTUtil.getStartOfADS(adsIter).getParent();
        }
    }

    public void addState(S newState, Word<I> accessSequence, O output) {
        FastMealyState target;
        Word<I> prefix = accessSequence.prefix(accessSequence.length() - 1);
        I sym = accessSequence.lastSymbol();
        FastMealyState pred = this.observationTree.getSuccessor((FastMealyState)this.observationTree.getInitialState(), prefix);
        assert (pred != null);
        if (pred.getTransitionObject(this.alphabet.getSymbolIndex(sym)) == null) {
            target = (FastMealyState)this.observationTree.addState();
            this.observationTree.addTransition(pred, sym, target, output);
        } else {
            target = this.observationTree.getSuccessor(pred, sym);
        }
        this.nodeToObservationMap.put(newState, target);
    }

    public Optional<Word<I>> findSeparatingWord(S s1, S s2, Word<I> prefix) {
        Word<I> sepWord;
        FastMealyState<O> n1 = this.nodeToObservationMap.get(s1);
        FastMealyState<O> n2 = this.nodeToObservationMap.get(s2);
        FastMealyState<O> s1Succ = this.observationTree.getSuccessor(n1, prefix);
        FastMealyState<O> s2Succ = this.observationTree.getSuccessor(n2, prefix);
        if (s1Succ != null && s2Succ != null && (sepWord = NearLinearEquivalenceTest.findSeparatingWord(this.observationTree, s1Succ, s2Succ, this.alphabet, true)) != null) {
            return Optional.of(sepWord);
        }
        return Optional.empty();
    }

    public Word<I> findSeparatingWord(S s1, S s2) {
        FastMealyState<O> n1 = this.nodeToObservationMap.get(s1);
        FastMealyState<O> n2 = this.nodeToObservationMap.get(s2);
        return NearLinearEquivalenceTest.findSeparatingWord(this.observationTree, n1, n2, this.alphabet, true);
    }

    public Word<O> trace(S s2, Word<I> input) {
        FastMealyState<O> q = this.nodeToObservationMap.get(s2);
        return this.observationTree.computeStateOutput(q, (Iterable)input);
    }
}

