/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.dhc.mealy;

import com.google.common.collect.Maps;
import de.learnlib.algorithm.dhc.mealy.MealyDHC;
import java.util.Map;
import java.util.Set;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.word.Word;

public class MealyDHCState<I, O> {
    private final Set<Word<I>> splitters;
    private final CompactMealy<I, O> hypothesis;
    private final Map<Integer, MealyDHC.QueueElement<I, O>> accessSequences;

    MealyDHCState(Set<Word<I>> splitters, CompactMealy<I, O> hypothesis, MutableMapping<Integer, MealyDHC.QueueElement<I, O>> accessSequences) {
        this.splitters = splitters;
        this.hypothesis = hypothesis;
        this.accessSequences = Maps.newHashMapWithExpectedSize(hypothesis.size());
        for (Integer s2 : hypothesis.getStates()) {
            MealyDHC.QueueElement elem = (MealyDHC.QueueElement)accessSequences.get(s2);
            if (elem == null) continue;
            this.accessSequences.put(s2, elem);
        }
    }

    Set<Word<I>> getSplitters() {
        return this.splitters;
    }

    CompactMealy<I, O> getHypothesis() {
        return this.hypothesis;
    }

    Map<Integer, MealyDHC.QueueElement<I, O>> getAccessSequences() {
        return this.accessSequences;
    }
}

