/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lstar;

import de.learnlib.algorithm.GlobalSuffixLearner;
import de.learnlib.algorithm.lstar.ce.ObservationTableCEXHandlers;
import de.learnlib.datastructure.observationtable.GenericObservationTable;
import de.learnlib.datastructure.observationtable.Inconsistency;
import de.learnlib.datastructure.observationtable.OTLearner;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;

public abstract class AbstractLStar<A, I, D>
implements OTLearner<A, I, D>,
GlobalSuffixLearner<A, I, D>,
SupportsGrowingAlphabet<I> {
    protected final Alphabet<I> alphabet;
    protected final MembershipOracle<I, D> oracle;
    protected GenericObservationTable<I, D> table;

    protected AbstractLStar(Alphabet<I> alphabet, MembershipOracle<I, D> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.table = new GenericObservationTable(alphabet);
    }

    @Override
    public void startLearning() {
        List<Word<I>> prefixes = this.initialPrefixes();
        List<Word<I>> suffixes = this.initialSuffixes();
        List<List<Row<I>>> initialUnclosed = this.table.initialize(prefixes, suffixes, this.oracle);
        this.completeConsistentTable(initialUnclosed, this.table.isInitialConsistencyCheckRequired());
    }

    @Override
    public final boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!MQUtil.isCounterexample(ceQuery, this.hypothesisOutput())) {
            return false;
        }
        int oldDistinctRows = this.table.numberOfDistinctRows();
        this.doRefineHypothesis(ceQuery);
        assert (this.table.numberOfDistinctRows() > oldDistinctRows);
        return true;
    }

    protected abstract SuffixOutput<I, D> hypothesisOutput();

    protected void doRefineHypothesis(DefaultQuery<I, D> ceQuery) {
        List<List<Row<I>>> unclosed = this.incorporateCounterExample(ceQuery);
        this.completeConsistentTable(unclosed, true);
    }

    protected List<List<Row<I>>> incorporateCounterExample(DefaultQuery<I, D> ce) {
        return ObservationTableCEXHandlers.handleClassicLStar(ce, this.table, this.oracle);
    }

    protected List<Word<I>> initialPrefixes() {
        return Collections.singletonList(Word.epsilon());
    }

    protected abstract List<Word<I>> initialSuffixes();

    protected boolean completeConsistentTable(List<List<Row<I>>> unclosed, boolean checkConsistency) {
        boolean refined = false;
        List<List<Row<I>>> unclosedIter = unclosed;
        while (true) {
            if (!unclosedIter.isEmpty()) {
                List<Row<I>> closingRows = this.selectClosingRows(unclosedIter);
                unclosedIter = this.table.toShortPrefixes(closingRows, this.oracle);
                refined = true;
                continue;
            }
            if (checkConsistency) {
                Inconsistency incons;
                do {
                    if ((incons = this.table.findInconsistency()) == null) continue;
                    Word newSuffix = this.analyzeInconsistency(incons);
                    unclosedIter = this.table.addSuffix(newSuffix, this.oracle);
                } while (unclosedIter.isEmpty() && incons != null);
            }
            if (unclosedIter.isEmpty()) break;
        }
        return refined;
    }

    protected List<Row<I>> selectClosingRows(List<List<Row<I>>> unclosed) {
        ArrayList<Row<I>> closingRows = new ArrayList<Row<I>>(unclosed.size());
        for (List<Row<I>> rowList : unclosed) {
            closingRows.add(rowList.get(0));
        }
        return closingRows;
    }

    protected Word<I> analyzeInconsistency(Inconsistency<I> incons) {
        int inputIdx = this.alphabet.getSymbolIndex(incons.getSymbol());
        Row<I> succRow1 = incons.getFirstRow().getSuccessor(inputIdx);
        Row<I> succRow2 = incons.getSecondRow().getSuccessor(inputIdx);
        int numSuffixes = this.table.getSuffixes().size();
        for (int i = 0; i < numSuffixes; ++i) {
            Object val2;
            Object val1 = this.table.cellContents(succRow1, i);
            if (Objects.equals(val1, val2 = this.table.cellContents(succRow2, i))) continue;
            I sym = this.alphabet.getSymbol(inputIdx);
            Word<I> suffix = this.table.getSuffixes().get(i);
            return suffix.prepend(sym);
        }
        throw new IllegalArgumentException("Bogus inconsistency");
    }

    @Override
    public Collection<Word<I>> getGlobalSuffixes() {
        return Collections.unmodifiableCollection(this.table.getSuffixes());
    }

    @Override
    public boolean addGlobalSuffixes(Collection<? extends Word<I>> newGlobalSuffixes) {
        List<List<Row<I>>> unclosed = this.table.addSuffixes(newGlobalSuffixes, this.oracle);
        if (unclosed.isEmpty()) {
            return false;
        }
        return this.completeConsistentTable(unclosed, false);
    }

    @Override
    public ObservationTable<I, D> getObservationTable() {
        return this.table;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        List<List<Row<I>>> unclosed = this.table.addAlphabetSymbol(symbol, this.oracle);
        this.completeConsistentTable(unclosed, true);
    }
}

