/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lstar.ce;

import de.learnlib.algorithm.lstar.ce.ObservationTableCEXHandler;
import de.learnlib.counterexample.GlobalSuffixFinder;
import de.learnlib.counterexample.GlobalSuffixFinders;
import de.learnlib.counterexample.LocalSuffixFinder;
import de.learnlib.counterexample.LocalSuffixFinders;
import de.learnlib.datastructure.observationtable.MutableObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.Query;
import java.util.Collections;
import java.util.List;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ObservationTableCEXHandlers {
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> CLASSIC_LSTAR = new ObservationTableCEXHandler<Object, Object>(){

        @Override
        public <RI, RD> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RD> ceQuery, MutableObservationTable<RI, RD> table, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return ObservationTableCEXHandlers.handleClassicLStar(ceQuery, table, oracle);
        }

        @Override
        public boolean needsConsistencyCheck() {
            return true;
        }

        public String toString() {
            return "ClassicLStar";
        }
    };
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> SUFFIX1BY1 = new ObservationTableCEXHandler<Object, Object>(){

        @Override
        public <RI, RD> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RD> ceQuery, MutableObservationTable<RI, RD> table, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return ObservationTableCEXHandlers.handleSuffix1by1(ceQuery, table, oracle);
        }

        @Override
        public boolean needsConsistencyCheck() {
            return false;
        }

        public String toString() {
            return "Suffix1by1";
        }
    };
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> MALER_PNUELI = ObservationTableCEXHandlers.fromGlobalSuffixFinder(GlobalSuffixFinders.MALER_PNUELI);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> SHAHBAZ = ObservationTableCEXHandlers.fromGlobalSuffixFinder(GlobalSuffixFinders.SHAHBAZ);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> FIND_LINEAR = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR, false);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> FIND_LINEAR_ALLSUFFIXES = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR, true);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> FIND_LINEAR_REVERSE = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR_REVERSE, false);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> FIND_LINEAR_REVERSE_ALLSUFFIXES = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.FIND_LINEAR_REVERSE, true);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> RIVEST_SCHAPIRE = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.RIVEST_SCHAPIRE, false);
    public static final ObservationTableCEXHandler<@Nullable Object, @Nullable Object> RIVEST_SCHAPIRE_ALLSUFFIXES = ObservationTableCEXHandlers.fromLocalSuffixFinder(LocalSuffixFinders.RIVEST_SCHAPIRE, true);

    private ObservationTableCEXHandlers() {
    }

    public static <I, D> ObservationTableCEXHandler<I, D> fromGlobalSuffixFinder(final GlobalSuffixFinder<I, D> globalFinder) {
        return new ObservationTableCEXHandler<I, D>(){

            @Override
            public <RI extends I, RD extends D> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RD> ceQuery, MutableObservationTable<RI, RD> table, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
                List<Word<RI>> suffixes = globalFinder.findSuffixes(ceQuery, table, hypOutput, oracle);
                return ObservationTableCEXHandlers.handleGlobalSuffixes(table, suffixes, oracle);
            }

            @Override
            public boolean needsConsistencyCheck() {
                return false;
            }

            public String toString() {
                return globalFinder.toString();
            }
        };
    }

    public static <I, D> List<List<Row<I>>> handleGlobalSuffixes(MutableObservationTable<I, D> table, List<? extends Word<I>> suffixes, MembershipOracle<I, D> oracle) {
        return table.addSuffixes(suffixes, oracle);
    }

    public static <I, D> ObservationTableCEXHandler<I, D> fromLocalSuffixFinder(LocalSuffixFinder<I, D> localFinder) {
        return ObservationTableCEXHandlers.fromLocalSuffixFinder(localFinder, false);
    }

    public static <I, D> ObservationTableCEXHandler<I, D> fromLocalSuffixFinder(final LocalSuffixFinder<I, D> localFinder, final boolean allSuffixes) {
        return new ObservationTableCEXHandler<I, D>(){

            @Override
            public <RI extends I, RD extends D> List<List<Row<RI>>> handleCounterexample(DefaultQuery<RI, RD> ceQuery, MutableObservationTable<RI, RD> table, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
                int suffixIdx = localFinder.findSuffixIndex(ceQuery, table, hypOutput, oracle);
                return ObservationTableCEXHandlers.handleLocalSuffix(ceQuery, table, suffixIdx, allSuffixes, oracle);
            }

            @Override
            public boolean needsConsistencyCheck() {
                return false;
            }

            public String toString() {
                return localFinder.toString();
            }
        };
    }

    public static <I, D> List<List<Row<I>>> handleLocalSuffix(Query<I, D> ceQuery, MutableObservationTable<I, D> table, int suffixIndex, MembershipOracle<I, D> oracle) {
        return ObservationTableCEXHandlers.handleLocalSuffix(ceQuery, table, suffixIndex, false, oracle);
    }

    public static <I, D> List<List<Row<I>>> handleLocalSuffix(Query<I, D> ceQuery, MutableObservationTable<I, D> table, int suffixIndex, boolean allSuffixes, MembershipOracle<I, D> oracle) {
        List<Word<I>> suffixes = GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, suffixIndex, allSuffixes);
        return ObservationTableCEXHandlers.handleGlobalSuffixes(table, suffixes, oracle);
    }

    public static <I, D> List<List<Row<I>>> handleClassicLStar(DefaultQuery<I, D> ceQuery, MutableObservationTable<I, D> table, MembershipOracle<I, D> oracle) {
        List prefixes = ceQuery.getInput().prefixes(false);
        return table.addShortPrefixes(prefixes, oracle);
    }

    public static <I, D> List<List<Row<I>>> handleSuffix1by1(DefaultQuery<I, D> ceQuery, MutableObservationTable<I, D> table, MembershipOracle<I, D> oracle) {
        Word suffix;
        List<List<Row<I>>> unclosed = Collections.emptyList();
        Word ceWord = ceQuery.getInput();
        int ceLen = ceWord.length();
        for (int i = 1; i <= ceLen && (unclosed = table.addSuffix(suffix = ceWord.suffix(i), oracle)).isEmpty(); ++i) {
        }
        return unclosed;
    }

    public static ObservationTableCEXHandler<@Nullable Object, @Nullable Object>[] values() {
        return new ObservationTableCEXHandler[]{CLASSIC_LSTAR, SUFFIX1BY1, MALER_PNUELI, SHAHBAZ, FIND_LINEAR, FIND_LINEAR_ALLSUFFIXES, FIND_LINEAR_REVERSE, FIND_LINEAR_REVERSE_ALLSUFFIXES, RIVEST_SCHAPIRE, RIVEST_SCHAPIRE_ALLSUFFIXES};
    }
}

