/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lstar.closing;

import de.learnlib.algorithm.lstar.closing.CloseRandomStrategy;
import de.learnlib.algorithm.lstar.closing.ClosingStrategy;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.common.util.comparison.CmpUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ClosingStrategies {
    public static final ClosingStrategy<@Nullable Object, @Nullable Object> CLOSE_RANDOM = new CloseRandomStrategy();
    public static final ClosingStrategy<@Nullable Object, @Nullable Object> CLOSE_FIRST = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RD> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RD> table, MembershipOracle<RI, RD> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>(unclosedClasses.size());
            for (List<Row<RI>> clazz : unclosedClasses) {
                result.add(clazz.get(0));
            }
            return result;
        }

        public String toString() {
            return "CloseFirst";
        }
    };
    public static final ClosingStrategy<@Nullable Object, @Nullable Object> CLOSE_SHORTEST = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RD> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RD> table, MembershipOracle<RI, RD> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>();
            for (List<Row<RI>> clazz : unclosedClasses) {
                Row<RI> shortest = null;
                int shortestLen = Integer.MAX_VALUE;
                for (Row<RI> row : clazz) {
                    int prefixLen = row.getLabel().length();
                    if (shortest != null && prefixLen >= shortestLen) continue;
                    shortest = row;
                    shortestLen = prefixLen;
                }
                assert (shortest != null);
                result.add(shortest);
            }
            return result;
        }

        public String toString() {
            return "CloseShortest";
        }
    };
    public static final ClosingStrategy<@Nullable Object, @Nullable Object> CLOSE_LEX_MIN = new ClosingStrategy<Object, Object>(){

        @Override
        public <RI, RD> List<Row<RI>> selectClosingRows(List<List<Row<RI>>> unclosedClasses, ObservationTable<RI, RD> table, MembershipOracle<RI, RD> oracle) {
            ArrayList<Row<RI>> result = new ArrayList<Row<RI>>(unclosedClasses.size());
            Alphabet<RI> alphabet = table.getInputAlphabet();
            for (List<Row<RI>> clazz : unclosedClasses) {
                Row<RI> lexMin = null;
                for (Row<RI> row : clazz) {
                    if (lexMin == null) {
                        lexMin = row;
                        continue;
                    }
                    if (CmpUtil.lexCompare(row.getLabel(), lexMin.getLabel(), alphabet) >= 0) continue;
                    lexMin = row;
                }
                assert (lexMin != null);
                result.add(lexMin);
            }
            return result;
        }

        public String toString() {
            return "CloseLexMin";
        }
    };

    private ClosingStrategies() {
    }

    public static ClosingStrategy<@Nullable Object, @Nullable Object>[] values() {
        return new ClosingStrategy[]{CLOSE_RANDOM, CLOSE_FIRST, CLOSE_SHORTEST, CLOSE_LEX_MIN};
    }
}

