/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.nlstar;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.nlstar.Inconsistency;
import de.learnlib.algorithm.nlstar.ObservationTable;
import de.learnlib.algorithm.nlstar.Row;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.CompactNFA;
import net.automatalib.util.automaton.fsa.NFAs;
import net.automatalib.word.Word;

public class NLStarLearner<I>
implements LearningAlgorithm.NFALearner<I> {
    private final Alphabet<I> alphabet;
    private final ObservationTable<I> table;
    private CompactNFA<I> hypothesis;

    public NLStarLearner(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle) {
        this.alphabet = alphabet;
        this.table = new ObservationTable<I>(alphabet, oracle);
    }

    @Override
    public void startLearning() {
        if (this.hypothesis != null) {
            throw new IllegalStateException();
        }
        List<List<Row<I>>> unclosed = this.table.initialize();
        this.completeConsistentTable(unclosed);
        this.constructHypothesis();
    }

    public LearningAlgorithm.DFALearner<I> asDFALearner() {
        return new LearningAlgorithm.DFALearner<I>(){

            public String toString() {
                return NLStarLearner.this.toString();
            }

            @Override
            public void startLearning() {
                NLStarLearner.this.startLearning();
            }

            @Override
            public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
                return NLStarLearner.this.refineHypothesis(ceQuery);
            }

            @Override
            public CompactDFA<I> getHypothesisModel() {
                return NLStarLearner.this.getDeterminizedHypothesis();
            }
        };
    }

    public CompactDFA<I> getDeterminizedHypothesis() {
        if (this.hypothesis == null) {
            throw new IllegalStateException();
        }
        return NFAs.determinize(this.hypothesis);
    }

    private void completeConsistentTable(List<List<Row<I>>> initialUnclosed) {
        List<List<Row<I>>> unclosed = initialUnclosed;
        while (true) {
            if (!unclosed.isEmpty()) {
                unclosed = this.fixUnclosed(unclosed);
                continue;
            }
            Inconsistency<I> incons = this.table.findInconsistency();
            if (incons != null) {
                unclosed = this.fixInconsistency(incons);
            }
            if (unclosed.isEmpty() && incons == null) break;
        }
    }

    private List<List<Row<I>>> fixUnclosed(List<List<Row<I>>> unclosed) {
        ArrayList newShort = new ArrayList(unclosed.size());
        for (List<Row<I>> unclosedClass : unclosed) {
            newShort.add(unclosedClass.get(0));
        }
        return this.table.makeUpper(newShort);
    }

    private List<List<Row<I>>> fixInconsistency(Inconsistency<I> incons) {
        I sym = this.alphabet.getSymbol(incons.getSymbolIdx());
        Word<I> oldSuffix = this.table.getSuffix(incons.getSuffixIdx());
        Word<I> newSuffix = oldSuffix.prepend(sym);
        return this.table.addSuffix(newSuffix);
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        if (this.hypothesis == null) {
            throw new IllegalStateException();
        }
        boolean refined = false;
        while (MQUtil.isCounterexample(ceQuery, this.hypothesis)) {
            Word ceWord = ceQuery.getInput();
            List<List<Row<I>>> unclosed = this.table.addSuffixes(ceWord.suffixes(false));
            this.completeConsistentTable(unclosed);
            this.constructHypothesis();
            refined = true;
        }
        return refined;
    }

    private void constructHypothesis() {
        int state;
        this.hypothesis = new CompactNFA<I>(this.alphabet);
        int[] stateMap = new int[this.table.getNumUpperRows()];
        Arrays.fill(stateMap, -1);
        List<Row<I>> upperPrimes = this.table.getUpperPrimes();
        for (Row<I> row : upperPrimes) {
            int state2;
            stateMap[row.getUpperId()] = state2 = this.hypothesis.addIntState(row.getContent(0));
        }
        Row<I> firstRow = this.table.getUpperRow(0);
        if (firstRow.isPrime()) {
            int state3 = stateMap[firstRow.getUpperId()];
            this.hypothesis.setInitial(state3, true);
        } else {
            for (Row<I> row : this.table.getCoveredRows(firstRow)) {
                if (!row.isPrime()) continue;
                state = stateMap[row.getUpperId()];
                this.hypothesis.setInitial(state, true);
            }
        }
        for (Row<I> row : upperPrimes) {
            state = stateMap[row.getUpperId()];
            for (int i = 0; i < this.alphabet.size(); ++i) {
                Row<I> succRow = row.getSuccessorRow(i);
                if (succRow.isPrime()) {
                    int succState = stateMap[succRow.getUpperId()];
                    this.hypothesis.addTransition(state, i, succState);
                    continue;
                }
                for (Row<I> r : succRow.getCoveredRows()) {
                    if (!r.isPrime()) continue;
                    int succState = stateMap[r.getUpperId()];
                    this.hypothesis.addTransition(state, i, succState);
                }
            }
        }
    }

    @Override
    public CompactNFA<I> getHypothesisModel() {
        if (this.hypothesis == null) {
            throw new IllegalStateException();
        }
        return this.hypothesis;
    }

    public ObservationTable<I> getObservationTable() {
        return this.table;
    }
}

