/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.nlstar;

import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.automatalib.word.Word;

public class Row<I> {
    private final Word<I> prefix;
    private final BitSet contents = new BitSet();
    private int upperId = -1;
    private Row<I>[] successorRows;
    private List<Row<I>> coveredRows;
    private boolean prime;

    public Row(Word<I> prefix) {
        this.prefix = prefix;
    }

    public boolean getContent(int index) {
        return this.contents.get(index);
    }

    public boolean isNew() {
        return this.coveredRows == null;
    }

    public boolean isPrime() {
        return this.prime;
    }

    public int getUpperId() {
        return this.upperId;
    }

    public Word<I> getPrefix() {
        return this.prefix;
    }

    public BitSet getContents() {
        return this.contents;
    }

    void makeShort(int id, int alphabetSize) {
        this.upperId = id;
        this.successorRows = new Row[alphabetSize];
    }

    Row<I> getSuccessorRow(int succIdx) {
        return this.successorRows[succIdx];
    }

    void setSuccessorRow(int succIdx, Row<I> row) {
        this.successorRows[succIdx] = row;
    }

    void updateCovered(List<Row<I>> newRows) {
        List<Row<I>> oldCovered = this.coveredRows;
        this.coveredRows = new ArrayList<Row<I>>();
        if (oldCovered != null) {
            this.checkAndAddCovered(oldCovered);
        }
        this.checkAndAddCovered(newRows);
    }

    private void checkAndAddCovered(List<Row<I>> rowList) {
        for (Row<I> row : rowList) {
            if (row == this) continue;
            if (this.isShortPrefixRow()) {
                if (!row.isShortPrefixRow() || !this.covers(row)) continue;
                this.coveredRows.add(row);
                continue;
            }
            if (!this.covers(row)) continue;
            this.coveredRows.add(row);
        }
    }

    public boolean isShortPrefixRow() {
        return this.successorRows != null;
    }

    boolean covers(Row<I> other) {
        BitSet c = (BitSet)this.contents.clone();
        c.or(other.contents);
        return this.contents.equals(c);
    }

    public List<Row<I>> getCoveredRows() {
        return this.coveredRows;
    }

    boolean checkPrime() {
        if (this.contents.isEmpty()) {
            this.prime = false;
        } else if (this.coveredRows.isEmpty()) {
            this.prime = true;
        } else {
            BitSet aggContents = new BitSet();
            for (Row<I> covered : this.coveredRows) {
                if (!covered.isShortPrefixRow() && this.contents.equals(covered.contents)) continue;
                aggContents.or(covered.contents);
            }
            this.prime = !this.contents.equals(aggContents);
        }
        return this.prime;
    }

    void fetchContents(Iterator<? extends DefaultQuery<I, Boolean>> queryIt, int offset, int num) {
        int idx = offset;
        for (int i = 0; i < num; ++i) {
            assert (queryIt.hasNext());
            boolean value = queryIt.next().getOutput();
            if (value) {
                this.contents.set(idx);
            }
            ++idx;
        }
    }
}

