/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.observationpack;

import de.learnlib.Resumable;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.observationpack.OPLearnerState;
import de.learnlib.algorithm.observationpack.hypothesis.HState;
import de.learnlib.algorithm.observationpack.hypothesis.HTransition;
import de.learnlib.algorithm.observationpack.hypothesis.OPLearnerHypothesis;
import de.learnlib.counterexample.LocalSuffixFinder;
import de.learnlib.counterexample.LocalSuffixFinders;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDiscriminationTree;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.Query;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractOPLearner<M extends SuffixOutput<I, D>, I, D, SP, TP>
implements LearningAlgorithm<M, I, D>,
SupportsGrowingAlphabet<I>,
Resumable<OPLearnerState<I, D, SP, TP>> {
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, D> oracle;
    private final LocalSuffixFinder<? super I, ? super D> suffixFinder;
    private final boolean repeatedCounterexampleEvaluation;
    private final List<HState<I, D, SP, TP>> newStates = new ArrayList<HState<I, D, SP, TP>>();
    private final List<HTransition<I, D, SP, TP>> newTransitions = new ArrayList<HTransition<I, D, SP, TP>>();
    private final Deque<HTransition<I, D, SP, TP>> openTransitions = new ArrayDeque<HTransition<I, D, SP, TP>>();
    private AbstractWordBasedDiscriminationTree<I, D, HState<I, D, SP, TP>> dtree;
    private OPLearnerHypothesis<I, D, SP, TP> hypothesis;

    protected AbstractOPLearner(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, LocalSuffixFinder<? super I, ? super D> suffixFinder, boolean repeatedCounterexampleEvaluation, AbstractWordBasedDiscriminationTree<I, D, HState<I, D, SP, TP>> dtree) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.suffixFinder = suffixFinder;
        this.hypothesis = new OPLearnerHypothesis(alphabet);
        this.dtree = dtree;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
    }

    @Override
    public void startLearning() {
        HState<I, D, SP, TP> init = this.hypothesis.createInitialState();
        AbstractWordBasedDTNode initDt = (AbstractWordBasedDTNode)this.dtree.sift(init.getAccessSequence());
        if (initDt.getData() != null) {
            throw new IllegalStateException("Decision tree already contains data");
        }
        initDt.setData(init);
        init.setDTLeaf(initDt);
        this.initializeState(init);
        this.updateHypothesis();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!this.refineHypothesisSingle(ceQuery)) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(ceQuery)) {
            }
        }
        return true;
    }

    protected boolean refineHypothesisSingle(DefaultQuery<I, D> ceQuery) {
        if (!MQUtil.isCounterexample(ceQuery, (SuffixOutput)this.getHypothesisModel())) {
            return false;
        }
        int suffixIdx = this.suffixFinder.findSuffixIndex(ceQuery, this.hypothesis, (SuffixOutput)this.getHypothesisModel(), this.oracle);
        if (suffixIdx == -1) {
            throw new AssertionError((Object)"Suffix finder does not work correctly, found no suffix for valid counterexample");
        }
        Word input = ceQuery.getInput();
        Word oldStateAs = input.prefix(suffixIdx);
        HState oldState = (HState)this.hypothesis.getState(oldStateAs);
        assert (oldState != null);
        AbstractWordBasedDTNode oldDt = oldState.getDTLeaf();
        Word newPredAs = input.prefix(suffixIdx - 1);
        HState newPred = (HState)this.hypothesis.getState(newPredAs);
        assert (newPred != null);
        Object transSym = input.getSymbol(suffixIdx - 1);
        int transIdx = this.alphabet.getSymbolIndex(transSym);
        HTransition trans = newPred.getTransition(transIdx);
        HState newState = this.createState(trans);
        Word suffix = input.subWord(suffixIdx);
        D oldOut = this.oracle.answerQuery(oldState.getAccessSequence(), suffix);
        D newOut = this.oracle.answerQuery(newState.getAccessSequence(), suffix);
        AbstractDTNode.SplitResult sr = oldDt.split(suffix, oldOut, newOut, newState);
        oldState.fetchNonTreeIncoming(this.openTransitions);
        oldState.setDTLeaf((AbstractWordBasedDTNode)sr.nodeOld);
        newState.setDTLeaf((AbstractWordBasedDTNode)sr.nodeNew);
        this.updateHypothesis();
        return true;
    }

    protected void initializeState(HState<I, D, SP, TP> newState) {
        this.newStates.add(newState);
        int size = this.alphabet.size();
        for (int i = 0; i < size; ++i) {
            I sym = this.alphabet.getSymbol(i);
            HTransition<I, D, SP, TP> newTrans = new HTransition<I, D, SP, TP>(newState, sym, (AbstractWordBasedDTNode)this.dtree.getRoot());
            newState.setTransition(i, newTrans);
            this.newTransitions.add(newTrans);
            this.openTransitions.offer(newTrans);
        }
    }

    protected void updateHypothesis() {
        while (!this.openTransitions.isEmpty()) {
            this.updateTransitions();
        }
        ArrayList<Query<I, D>> queries = new ArrayList<Query<I, D>>();
        for (HState<I, D, SP, TP> hState : this.newStates) {
            Query<I, D> spQuery = this.spQuery(hState);
            if (spQuery == null) continue;
            queries.add(spQuery);
        }
        this.newStates.clear();
        for (HTransition hTransition : this.newTransitions) {
            Query<I, D> tpQuery = this.tpQuery(hTransition);
            if (tpQuery == null) continue;
            queries.add(tpQuery);
        }
        this.newTransitions.clear();
        this.oracle.processQueries(queries);
    }

    protected void updateTransitions() {
        ArrayList<HTransition<I, D, SP, TP>> transitionsToSift = new ArrayList<HTransition<I, D, SP, TP>>(this.openTransitions.size());
        ArrayList<AbstractWordBasedDTNode<I, D, HState<I, D, SP, TP>>> nodes = new ArrayList<AbstractWordBasedDTNode<I, D, HState<I, D, SP, TP>>>(this.openTransitions.size());
        ArrayList prefixes = new ArrayList(this.openTransitions.size());
        for (HTransition<I, D, SP, TP> t : this.openTransitions) {
            if (t.isTree()) continue;
            transitionsToSift.add(t);
            nodes.add(t.getDT());
            prefixes.add(t.getAccessSequence());
        }
        this.openTransitions.clear();
        List results = this.dtree.sift(nodes, prefixes);
        for (int i = 0; i < transitionsToSift.size(); ++i) {
            HTransition trans = (HTransition)transitionsToSift.get(i);
            AbstractWordBasedDTNode currDt = (AbstractWordBasedDTNode)results.get(i);
            trans.setDT(currDt);
            HState<I, D, SP, TP> state = (HState<I, D, SP, TP>)currDt.getData();
            if (state == null) {
                state = this.createState(trans);
                currDt.setData(state);
                state.setDTLeaf(currDt);
                continue;
            }
            state.addNonTreeIncoming(trans);
        }
    }

    protected abstract @Nullable Query<I, D> spQuery(HState<I, D, SP, TP> var1);

    protected abstract @Nullable Query<I, D> tpQuery(HTransition<I, D, SP, TP> var1);

    protected HState<I, D, SP, TP> createState(HTransition<I, D, SP, TP> trans) {
        HState<I, D, SP, TP> newState = this.hypothesis.createState(trans);
        this.initializeState(newState);
        return newState;
    }

    public AbstractWordBasedDiscriminationTree<I, D, HState<I, D, SP, TP>> getDiscriminationTree() {
        return this.dtree;
    }

    public OPLearnerHypothesis<I, D, SP, TP> getHypothesisDS() {
        return this.hypothesis;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor(this.hypothesis.getInitialState(), symbol) == null) {
            int newSymbolIdx = this.alphabet.getSymbolIndex(symbol);
            for (HState<I, D, SP, TP> s2 : this.hypothesis.getStates()) {
                HTransition<I, D, SP, TP> newTrans = new HTransition<I, D, SP, TP>(s2, symbol, (AbstractWordBasedDTNode)this.dtree.getRoot());
                s2.setTransition(newSymbolIdx, newTrans);
                this.newTransitions.add(newTrans);
                this.openTransitions.add(newTrans);
            }
            this.updateHypothesis();
        }
    }

    @Override
    public OPLearnerState<I, D, SP, TP> suspend() {
        return new OPLearnerState<I, D, SP, TP>(this.dtree, this.hypothesis);
    }

    @Override
    public void resume(OPLearnerState<I, D, SP, TP> state) {
        this.hypothesis = state.getHypothesis();
        this.dtree = state.getDtree();
        this.dtree.setOracle(this.oracle);
    }

    public static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static <I, O> LocalSuffixFinder<? super I, ? super O> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }
    }
}

