/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.lstar;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.oml.lstar.AbstractOptimalLStar;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.word.Word;

public class OptimalLStarDFA<I>
extends AbstractOptimalLStar<DFA<?, I>, I, Boolean>
implements LearningAlgorithm.DFALearner<I> {
    private CompactDFA<I> hypothesis;
    private MutableMapping<Integer, List<Boolean>> hypStateMap;

    public OptimalLStarDFA(Alphabet<I> sigma, MembershipOracle<I, Boolean> mqo) {
        this(sigma, mqo, mqo);
    }

    public OptimalLStarDFA(Alphabet<I> sigma, MembershipOracle<I, Boolean> mqs, MembershipOracle<I, Boolean> ceqs) {
        super(sigma, mqs, ceqs, Collections.singletonList(Word.epsilon()));
    }

    @Override
    int maxSearchIndex(int ceLength) {
        return ceLength;
    }

    @Override
    boolean symbolInconsistency(Word<I> u1, Word<I> u2, I a) {
        return false;
    }

    @Override
    void automatonFromTable() {
        Alphabet alphabet = this.getInputAlphabet();
        this.hypothesis = new CompactDFA(alphabet);
        HashMap stateMap = new HashMap();
        List rowData = this.getRow(Word.epsilon());
        Object q = (Integer)this.hypothesis.addInitialState((Boolean)rowData.get(0));
        stateMap.put(rowData, q);
        for (Word word : this.getShortPrefixes()) {
            rowData = this.getRow(word);
            if (stateMap.containsKey(rowData)) continue;
            q = this.hypothesis.addState((Object)((Boolean)rowData.get(0)));
            stateMap.put(rowData, q);
        }
        this.hypStateMap = this.hypothesis.createStaticStateMapping();
        for (Map.Entry entry : stateMap.entrySet()) {
            List sig = (List)entry.getKey();
            Integer state = (Integer)entry.getValue();
            this.hypStateMap.put(state, sig);
            Word u = this.getShortPrefixes(sig).get(0);
            for (Object a : alphabet) {
                List dstData = this.getRow(u.append(a));
                assert (dstData != null);
                Integer dst = (Integer)stateMap.get(dstData);
                this.hypothesis.setTransition(state, a, dst);
            }
        }
    }

    @Override
    Boolean suffix(Boolean output, int length) {
        return output;
    }

    @Override
    public int size() {
        return this.hypothesis.size();
    }

    @Override
    public List<Boolean> rowForState(Word<I> input) {
        return (List)this.hypStateMap.get((Integer)this.hypothesis.getState((Iterable)input));
    }

    @Override
    public Boolean getOutput(Word<I> input, int length) {
        return this.hypothesis.accepts(input);
    }

    @Override
    public DFA<?, I> getHypothesisModel() {
        return this.hypothesis;
    }
}

