/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ostia;

import de.learnlib.algorithm.ostia.Edge;
import de.learnlib.algorithm.ostia.IntQueue;
import de.learnlib.algorithm.ostia.Out;
import de.learnlib.algorithm.ostia.State;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.SubsequentialTransducer;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class OSSTWrapper<I, O>
implements SubsequentialTransducer<State, I, Edge, O> {
    private final State root;
    private final Alphabet<I> inputAlphabet;
    private final Alphabet<O> outputAlphabet;

    OSSTWrapper(State root, Alphabet<I> inputAlphabet, Alphabet<O> outputAlphabet) {
        this.root = root;
        this.inputAlphabet = inputAlphabet;
        this.outputAlphabet = outputAlphabet;
    }

    @Override
    public Collection<State> getStates() {
        LinkedHashSet<State> cache = new LinkedHashSet<State>();
        ArrayDeque<State> queue = new ArrayDeque<State>();
        queue.add(this.root);
        while (!queue.isEmpty()) {
            @NonNull State s2 = (State)queue.poll();
            cache.add(s2);
            for (Edge transition : s2.transitions) {
                State succ;
                if (transition == null || (succ = transition.target) == null || cache.contains(succ)) continue;
                queue.add(succ);
                cache.add(succ);
            }
        }
        return cache;
    }

    @Override
    public @Nullable Edge getTransition(State state, I input) {
        return state.transitions[this.inputAlphabet.getSymbolIndex(input)];
    }

    @Override
    public State getInitialState() {
        return this.root;
    }

    @Override
    public Word<O> getStateProperty(State state) {
        return this.outToWord(state.out);
    }

    @Override
    public Word<O> getTransitionProperty(Edge transition) {
        return this.outToWord(transition.out);
    }

    @Override
    public State getSuccessor(Edge transition) {
        return transition.target;
    }

    private Word<O> outToWord(@Nullable Out out) {
        return this.outToWord(out == null ? null : out.str);
    }

    private Word<O> outToWord(@Nullable IntQueue out) {
        if (out == null) {
            return Word.epsilon();
        }
        WordBuilder<O> wb = new WordBuilder<O>();
        IntQueue outIter = out;
        while (outIter != null) {
            wb.add(this.outputAlphabet.getSymbol(outIter.value));
            outIter = outIter.next;
        }
        return wb.toWord();
    }
}

