/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ostia;

import de.learnlib.algorithm.ostia.Edge;
import de.learnlib.algorithm.ostia.IntQueue;
import de.learnlib.algorithm.ostia.Out;
import de.learnlib.algorithm.ostia.State;
import de.learnlib.algorithm.ostia.StateParent;
import org.checkerframework.checker.nullness.qual.Nullable;

class StateCopy
extends StateParent {
    final State original;

    StateCopy(State original) {
        this.out = original.out == null ? null : new Out(IntQueue.copyAndConcat(original.out.str, null));
        this.transitions = StateCopy.copyTransitions(original.transitions);
        this.original = original;
    }

    private static @Nullable Edge[] copyTransitions(@Nullable Edge[] transitions) {
        @Nullable Edge[] copy = new Edge[transitions.length];
        for (int i = 0; i < copy.length; ++i) {
            @Nullable Edge edge = transitions[i];
            copy[i] = edge == null ? null : new Edge(edge);
        }
        return copy;
    }

    void assign() {
        this.original.out = this.out;
        this.original.transitions = this.transitions;
    }

    void prepend(@Nullable IntQueue prefix) {
        for (Edge edge : this.transitions) {
            if (edge == null) continue;
            edge.out = IntQueue.copyAndConcat(prefix, edge.out);
        }
        if (this.out == null) {
            this.out = new Out(prefix);
        } else {
            this.out.str = IntQueue.copyAndConcat(prefix, this.out.str);
        }
    }
}

