/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.spa.manager;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.learnlib.AccessSequenceTransformer;
import de.learnlib.algorithm.procedural.spa.ATRManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OptimizingATRManager<I>
implements ATRManager<I> {
    private final Map<I, Word<I>> accessSequences;
    private final Map<I, Word<I>> returnSequences;
    private final Map<I, Word<I>> terminatingSequences;
    private final ProceduralInputAlphabet<I> alphabet;

    public OptimizingATRManager(ProceduralInputAlphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.accessSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        this.returnSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        this.terminatingSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
    }

    @Override
    public Word<I> getAccessSequence(I procedure) {
        assert (this.accessSequences.containsKey(procedure));
        return this.accessSequences.get(procedure);
    }

    @Override
    public Word<I> getTerminatingSequence(I procedure) {
        assert (this.terminatingSequences.containsKey(procedure));
        return this.terminatingSequences.get(procedure);
    }

    @Override
    public Word<I> getReturnSequence(I procedure) {
        assert (this.returnSequences.containsKey(procedure));
        return this.returnSequences.get(procedure);
    }

    @Override
    public Set<I> scanPositiveCounterexample(Word<I> input) {
        HashSet newProcedures = Sets.newHashSetWithExpectedSize(this.alphabet.getNumCalls() - this.terminatingSequences.size());
        this.extractPotentialTerminatingSequences(input, newProcedures);
        this.extractPotentialAccessAndReturnSequences(input);
        return newProcedures;
    }

    @Override
    public void scanProcedures(Map<I, ? extends DFA<?, I>> procedures, Map<I, ? extends AccessSequenceTransformer<I>> providers, Collection<I> inputs) {
        if (!procedures.isEmpty()) {
            boolean foundImprovements = false;
            boolean stable = false;
            while (!stable) {
                stable = true;
                for (Map.Entry<I, DFA<?, I>> entry : procedures.entrySet()) {
                    I i = entry.getKey();
                    DFA<?, I> automaton = entry.getValue();
                    Word<I> currentTS = this.getTerminatingSequence(i);
                    assert (providers.containsKey(i));
                    Word<I> hypTS = this.getShortestHypothesisTS(automaton, providers.get(i), inputs);
                    if (hypTS == null || hypTS.size() >= currentTS.size()) continue;
                    this.terminatingSequences.put(i, hypTS);
                    stable = false;
                    foundImprovements = true;
                }
            }
            if (foundImprovements) {
                this.optimizeSequences(this.accessSequences);
                this.optimizeSequences(this.terminatingSequences);
                this.optimizeSequences(this.returnSequences);
            }
        }
    }

    private <S> @Nullable Word<I> getShortestHypothesisTS(DFA<S, I> hyp, AccessSequenceTransformer<I> asTransformer, Collection<I> inputs) {
        return Streams.stream(Covers.stateCoverIterator(hyp, inputs)).filter(hyp::accepts).map(asTransformer::transformAccessSequence).map(as -> this.alphabet.expand((Iterable<Object>)as, this.terminatingSequences::get)).min(Comparator.comparingInt(Word::size)).orElse(null);
    }

    private void optimizeSequences(Map<I, Word<I>> sequences) {
        for (Map.Entry<I, Word<I>> entry : sequences.entrySet()) {
            Word<I> currentSequence = entry.getValue();
            Word<I> minimized = this.minifyWellMatched(currentSequence);
            if (minimized.size() >= currentSequence.size()) continue;
            sequences.put(entry.getKey(), minimized);
        }
    }

    private void extractPotentialTerminatingSequences(Word<I> input, Set<I> newProcedures) {
        for (int i = 0; i < input.size(); ++i) {
            I sym = input.getSymbol(i);
            if (!this.alphabet.isCallSymbol(sym)) continue;
            int returnIdx = this.alphabet.findReturnIndex(input, i + 1);
            Word<I> potentialTermSeq = input.subWord(i + 1, returnIdx);
            Word<I> currentTermSeq = this.terminatingSequences.get(sym);
            if (currentTermSeq == null) {
                newProcedures.add(sym);
                this.terminatingSequences.put(sym, potentialTermSeq);
                continue;
            }
            if (potentialTermSeq.size() >= currentTermSeq.size()) continue;
            this.terminatingSequences.put(sym, potentialTermSeq);
        }
    }

    private void extractPotentialAccessAndReturnSequences(Word<I> input) {
        ArrayList<Object> asBuilder = new ArrayList<Object>(input.size());
        ArrayList<I> rsBuilder = new ArrayList<I>(input.size());
        rsBuilder.addAll(this.minifyWellMatched(input).asList());
        for (int i = 0; i < input.size(); ++i) {
            I sym = input.getSymbol(i);
            asBuilder.add(sym);
            if (this.alphabet.isCallSymbol(sym)) {
                int returnIdx = this.alphabet.findReturnIndex(rsBuilder, 1);
                List potentialFinSeq = rsBuilder.subList(returnIdx, rsBuilder.size());
                Word<I> currentAccSeq = this.accessSequences.get(sym);
                Word<I> currentFinSeq = this.returnSequences.get(sym);
                if (currentAccSeq == null || currentFinSeq == null || asBuilder.size() + potentialFinSeq.size() < currentAccSeq.size() + currentFinSeq.size()) {
                    this.accessSequences.put(sym, Word.fromList(asBuilder));
                    this.returnSequences.put(sym, Word.fromList(potentialFinSeq));
                }
            } else if (this.alphabet.isReturnSymbol(sym)) {
                int callIdx = this.alphabet.findCallIndex(asBuilder, asBuilder.size() - 1);
                Object procedure = asBuilder.get(callIdx);
                asBuilder.subList(callIdx + 1, asBuilder.size() - 1).clear();
                asBuilder.addAll(callIdx + 1, this.getTerminatingSequence(procedure).asList());
            }
            rsBuilder.remove(0);
            if (!this.alphabet.isCallSymbol(sym)) continue;
            int rsBuilderReturnIdx = this.alphabet.findReturnIndex(rsBuilder, 0);
            int inputReturnIdx = this.alphabet.findReturnIndex(input, i + 1);
            rsBuilder.subList(0, rsBuilderReturnIdx).clear();
            rsBuilder.addAll(0, this.minifyWellMatched(input.subWord(i + 1, inputReturnIdx)).asList());
        }
    }

    private Word<I> minifyWellMatched(Word<I> input) {
        if (input.isEmpty()) {
            return Word.epsilon();
        }
        WordBuilder<I> wb = new WordBuilder<I>(input.size());
        for (int i = 0; i < input.size(); ++i) {
            int returnIdx;
            I sym = input.getSymbol(i);
            wb.append(sym);
            if (!this.alphabet.isCallSymbol(sym) || (returnIdx = this.alphabet.findReturnIndex(input, i + 1)) <= -1) continue;
            wb.append(this.terminatingSequences.get(sym));
            wb.append(this.alphabet.getReturnSymbol());
            i = returnIdx;
        }
        return wb.toWord();
    }
}

