/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.rpni;

import de.learnlib.algorithm.PassiveLearningAlgorithm;
import de.learnlib.datastructure.pta.BlueFringePTA;
import de.learnlib.datastructure.pta.BlueFringePTAState;
import de.learnlib.datastructure.pta.PTATransition;
import de.learnlib.datastructure.pta.RedBlueMerge;
import de.learnlib.datastructure.pta.config.DefaultProcessingOrders;
import de.learnlib.datastructure.pta.config.ProcessingOrder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Stream;
import net.automatalib.alphabet.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBlueFringeRPNI<I, D, SP, TP, M>
implements PassiveLearningAlgorithm<M, I, D> {
    protected final Alphabet<I> alphabet;
    protected final int alphabetSize;
    private ProcessingOrder order = DefaultProcessingOrders.CANONICAL_ORDER;
    private boolean parallel;
    private boolean deterministic;

    public AbstractBlueFringeRPNI(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public void setProcessingOrder(ProcessingOrder order) {
        this.order = order;
    }

    @Override
    public M computeModel() {
        PTATransition qbRef;
        BlueFringePTA<SP, TP> pta = this.fetchPTA();
        Queue blue = this.order.createWorklist();
        pta.init(blue::offer);
        while ((qbRef = blue.poll()) != null) {
            Optional<RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP>> result;
            BlueFringePTAState qb = (BlueFringePTAState)qbRef.getTarget();
            assert (qb != null);
            List redStates = pta.getRedStates();
            Stream stream = this.parallel ? redStates.parallelStream() : redStates.stream();
            Stream<RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP>> possibleMerges = stream.map(qr -> this.tryMerge(pta, (BlueFringePTAState<SP, TP>)qr, qb)).filter(Objects::nonNull);
            Stream<RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP>> filteredMerges = this.selectMerges(possibleMerges);
            Optional<RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP>> optional = result = this.deterministic ? filteredMerges.findFirst() : filteredMerges.findAny();
            if (result.isPresent()) {
                RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP> mod = result.get();
                mod.apply(pta, blue::offer);
                continue;
            }
            pta.promote(qb, blue::offer);
        }
        return this.ptaToModel(pta);
    }

    protected abstract BlueFringePTA<SP, TP> fetchPTA();

    protected @Nullable RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP> tryMerge(BlueFringePTA<SP, TP> pta, BlueFringePTAState<SP, TP> qr, BlueFringePTAState<SP, TP> qb) {
        return pta.tryMerge(qr, qb);
    }

    protected abstract M ptaToModel(BlueFringePTA<SP, TP> var1);

    protected Stream<RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP>> selectMerges(Stream<RedBlueMerge<BlueFringePTAState<SP, TP>, SP, TP>> merges) {
        return merges;
    }
}

