/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.rpni;

import java.util.List;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.common.smartcollection.IntSeq;

final class MDLUtil {
    private MDLUtil() {
    }

    static <S, I> double score(UniversalDeterministicAutomaton<S, Integer, ?, Boolean, ?> merged, int alphabetSize, List<IntSeq> positiveSamples) {
        double sampleScore = 0.0;
        for (IntSeq w : positiveSamples) {
            sampleScore += MDLUtil.countWordChoices(merged, alphabetSize, w);
        }
        return (double)(merged.size() * alphabetSize) + sampleScore;
    }

    private static <S, I> double countWordChoices(UniversalDeterministicAutomaton<S, Integer, ?, Boolean, ?> merged, int alphabetSize, IntSeq word) {
        Object currentState = merged.getInitialState();
        assert (currentState != null);
        double result = Math.log(MDLUtil.countStateChoices(merged, alphabetSize, currentState)) / Math.log(2.0);
        for (Integer i : word) {
            currentState = merged.getSuccessor(currentState, i);
            assert (currentState != null);
            result += Math.log(MDLUtil.countStateChoices(merged, alphabetSize, currentState)) / Math.log(2.0);
        }
        return result;
    }

    private static <S, I> int countStateChoices(UniversalDeterministicAutomaton<S, Integer, ?, Boolean, ?> pta, int alphabetSize, S state) {
        int choices = Boolean.TRUE.equals(pta.getStateProperty(state)) ? 1 : 0;
        for (int i = 0; i < alphabetSize; ++i) {
            if (pta.getSuccessor(state, i) == null) continue;
            ++choices;
        }
        return choices;
    }
}

