/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.moore;

import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.MooreOutInconsPrefixTransformAcex;
import de.learnlib.acex.OutInconsPrefixTransformAcex;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.AbstractTTTLearner;
import de.learnlib.algorithm.ttt.base.BaseTTTDiscriminationTree;
import de.learnlib.algorithm.ttt.base.OutputInconsistency;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.algorithm.ttt.base.TTTTransition;
import de.learnlib.algorithm.ttt.moore.TTTDTNodeMoore;
import de.learnlib.algorithm.ttt.moore.TTTHypothesisMoore;
import de.learnlib.algorithm.ttt.moore.TTTStateMoore;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.moore.MooreUtil;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class TTTLearnerMoore<I, O>
extends AbstractTTTLearner<MooreMachine<?, I, ?, O>, I, Word<O>>
implements LearningAlgorithm.MooreLearner<I, O> {
    public TTTLearnerMoore(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, AcexAnalyzer analyzer) {
        super(alphabet, oracle, new TTTHypothesisMoore(alphabet), new BaseTTTDiscriminationTree<I, Word<O>>(oracle, TTTDTNodeMoore::new), analyzer);
        ((AbstractBaseDTNode)this.dtree.getRoot()).split(Word.epsilon(), oracle.answerQuery(Word.epsilon()));
    }

    @Override
    protected Word<O> succEffect(Word<O> effect) {
        return effect.subWord(1);
    }

    @Override
    protected Word<O> predictSuccOutcome(TTTTransition<I, Word<O>> trans, AbstractBaseDTNode<I, Word<O>> succSeparator) {
        TTTStateMoore curr = (TTTStateMoore)trans.getSource();
        Word label = (Word)succSeparator.subtreeLabel(trans.getDTTarget());
        assert (label != null);
        return label.prepend(curr.getOutput());
    }

    @Override
    protected void initializeState(TTTState<I, Word<O>> state) {
        super.initializeState(state);
        TTTStateMoore mooreState = (TTTStateMoore)state;
        Word label = (Word)((AbstractBaseDTNode)this.dtree.getRoot()).subtreeLabel(mooreState.getDTLeaf());
        assert (label != null && !label.isEmpty());
        mooreState.setOutput(label.firstSymbol());
    }

    @Override
    protected boolean refineHypothesisSingle(DefaultQuery<I, Word<O>> ceQuery) {
        DefaultQuery<I, Word<O>> shortenedCeQuery = MooreUtil.shortenCounterExample((TTTHypothesisMoore)this.hypothesis, ceQuery);
        return shortenedCeQuery != null && super.refineHypothesisSingle(shortenedCeQuery);
    }

    @Override
    protected OutInconsPrefixTransformAcex<I, Word<O>> deriveAcex(OutputInconsistency<I, Word<O>> outIncons) {
        TTTState source = outIncons.srcState;
        Word suffix = outIncons.suffix;
        MooreOutInconsPrefixTransformAcex acex = new MooreOutInconsPrefixTransformAcex(suffix, this.oracle, w -> this.getDeterministicState(source, w).getAccessSequence());
        acex.setEffect(0, (Word)outIncons.targetOut);
        Object lastHypOut = this.computeHypothesisOutput(this.getAnySuccessor(source, suffix), Word.epsilon());
        acex.setEffect(suffix.length(), lastHypOut);
        return acex;
    }

    @Override
    protected Word<O> computeHypothesisOutput(TTTState<I, Word<O>> state, Word<I> suffix) {
        TTTStateMoore curr = (TTTStateMoore)state;
        WordBuilder wb = new WordBuilder(suffix.length());
        wb.append(curr.output);
        if (suffix.isEmpty()) {
            return wb.toWord();
        }
        for (I sym : suffix) {
            curr = (TTTStateMoore)this.getAnySuccessor(curr, sym);
            wb.append(curr.output);
        }
        return wb.toWord();
    }

    @Override
    protected AbstractBaseDTNode<I, Word<O>> createNewNode(AbstractBaseDTNode<I, Word<O>> parent, Word<O> parentOutput) {
        return new TTTDTNodeMoore<I, Word<O>>(parent, parentOutput);
    }

    @Override
    public TTTHypothesisMoore<I, O> getHypothesisModel() {
        return (TTTHypothesisMoore)this.hypothesis;
    }
}

