/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.discriminationtree;

import de.learnlib.datastructure.list.IntrusiveList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SplitData<O, T extends IntrusiveList<?>> {
    private final Set<O> marks = new HashSet<O>();
    private final Map<O, T> incomingTransitions = new HashMap<O, T>();
    private final Supplier<T> listSuppllier;
    private O stateLabel;

    public SplitData(Supplier<T> listSuppllier) {
        this.listSuppllier = listSuppllier;
    }

    public boolean mark(O label) {
        return this.marks.add(label);
    }

    public Set<O> getLabels() {
        return this.marks;
    }

    public O getStateLabel() {
        assert (this.hasStateLabel());
        return this.stateLabel;
    }

    public void setStateLabel(O label) {
        assert (!this.hasStateLabel());
        this.stateLabel = label;
    }

    public boolean hasStateLabel() {
        return this.stateLabel != null;
    }

    public T getIncoming(O label) {
        return (T)this.incomingTransitions.computeIfAbsent(label, k -> (IntrusiveList)this.listSuppllier.get());
    }

    public boolean isMarked(O label) {
        return this.marks.contains(label);
    }
}

