/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.discriminationtree.model;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BooleanMap<V>
extends AbstractMap<Boolean, V> {
    private V falseValue;
    private V trueValue;

    public BooleanMap() {
    }

    public BooleanMap(V falseValue, V trueValue) {
        this.falseValue = falseValue;
        this.trueValue = trueValue;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals(this.falseValue, value) || Objects.equals(this.trueValue, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && key.getClass() == Boolean.class;
    }

    @Override
    public @Nullable V get(Object key) {
        if (key == null || key.getClass() != Boolean.class) {
            return null;
        }
        boolean bval = (Boolean)key;
        return this.get(bval);
    }

    public V get(boolean key) {
        if (key) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    @Override
    public V put(Boolean key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("BooleanMap disallows null keys");
        }
        boolean bval = key;
        return this.put(bval, value);
    }

    @Override
    public V put(boolean key, V value) {
        V old;
        if (key) {
            old = this.trueValue;
            this.trueValue = value;
        } else {
            old = this.falseValue;
            this.falseValue = value;
        }
        return old;
    }

    @Override
    public @Nullable V remove(Object key) {
        if (key == null || key.getClass() != Boolean.class) {
            return null;
        }
        throw new UnsupportedOperationException("BooleanMap disallows removal");
    }

    @Override
    public void putAll(Map<? extends Boolean, ? extends V> m3) {
        if (m3.containsKey(null)) {
            throw new IllegalArgumentException("BooleanMap disallows null keys");
        }
        if (m3.containsKey(false)) {
            this.falseValue = m3.get(false);
        }
        if (m3.containsKey(true)) {
            this.trueValue = m3.get(true);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("BooleanMap disallows removal");
    }

    @Override
    public Set<Boolean> keySet() {
        return BooleanSet.INSTANCE;
    }

    @Override
    public Collection<V> values() {
        return Arrays.asList(this.falseValue, this.trueValue);
    }

    @Override
    public Set<Map.Entry<Boolean, V>> entrySet() {
        HashSet<Map.Entry<Boolean, V>> entries = new HashSet<Map.Entry<Boolean, V>>(2);
        entries.add(new Entry(false));
        entries.add(new Entry(true));
        return entries;
    }

    private final class Entry
    implements Map.Entry<Boolean, V> {
        private final boolean key;

        Entry(boolean key) {
            this.key = key;
        }

        @Override
        public Boolean getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return BooleanMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return BooleanMap.this.put(this.key, value);
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.key);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry that = (Entry)o;
            return Objects.equals(this.key, that.key);
        }
    }

    private static class BooleanSet
    extends AbstractSet<Boolean> {
        private static final List<Boolean> VALUES = Arrays.asList(false, true);
        private static final BooleanSet INSTANCE = new BooleanSet();

        private BooleanSet() {
        }

        @Override
        public Iterator<Boolean> iterator() {
            return VALUES.iterator();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return o.getClass() == Boolean.class;
        }
    }
}

