/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.list;

import com.google.common.collect.AbstractIterator;
import de.learnlib.datastructure.list.IntrusiveListElem;
import de.learnlib.datastructure.list.IntrusiveListElemImpl;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntrusiveList<T extends IntrusiveListElem<T>>
extends IntrusiveListElemImpl<T>
implements Iterable<T> {
    @EnsuresNonNullIf(expression={"next"}, result=false)
    public boolean isEmpty() {
        return this.next == null;
    }

    public @Nullable T choose() {
        return (T)((IntrusiveListElem)this.next);
    }

    public int size() {
        int i = 0;
        for (IntrusiveListElem curr = (IntrusiveListElem)this.next; curr != null; curr = (IntrusiveListElem)curr.getNextElement()) {
            ++i;
        }
        return i;
    }

    @Override
    public Iterator<T> iterator() {
        return new ListIterator(this, (IntrusiveListElem)this.next);
    }

    private static class ListIterator
    extends AbstractIterator<T> {
        private @Nullable T cursor;
        final /* synthetic */ IntrusiveList this$0;

        ListIterator(T start) {
            this.this$0 = var1_1;
            this.cursor = start;
        }

        @Override
        protected @Nullable T computeNext() {
            if (this.cursor == null) {
                return (IntrusiveListElem)this.endOfData();
            }
            Object result = this.cursor;
            this.cursor = (IntrusiveListElem)this.cursor.getNextElement();
            return result;
        }
    }
}

