/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.datastructure.observationtable.MutableObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.datastructure.observationtable.RowImpl;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class GenericObservationTable<I, D>
implements MutableObservationTable<I, D> {
    private static final int NO_ENTRY = -1;
    private final List<RowImpl<I>> shortPrefixRows = new ArrayList<RowImpl<I>>();
    private final List<RowImpl<I>> longPrefixRows = new ArrayList<RowImpl<I>>();
    private final List<RowImpl<I>> allRows = new ArrayList<RowImpl<I>>();
    private final List<List<D>> allRowContents = new ArrayList<List<D>>();
    private final List<@Nullable RowImpl<I>> canonicalRows = new ArrayList<RowImpl<I>>();
    private final Map<List<D>, Integer> rowContentIds = new HashMap<List<D>, Integer>();
    private final Map<Word<I>, RowImpl<I>> rowMap = new HashMap<Word<I>, RowImpl<I>>();
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();
    private final Set<Word<I>> suffixSet = new HashSet<Word<I>>();
    private final Alphabet<I> alphabet;
    private int alphabetSize;
    private int numRows;
    private boolean initialConsistencyCheckRequired;

    public GenericObservationTable(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.alphabetSize = alphabet.size();
    }

    private static <I, D> void buildQueries(List<DefaultQuery<I, D>> queryList, Word<I> prefix, List<? extends Word<I>> suffixes) {
        for (Word<I> suffix : suffixes) {
            queryList.add(new DefaultQuery<I, Word<I>>(prefix, suffix));
        }
    }

    @Override
    public List<List<Row<I>>> initialize(List<Word<I>> initialShortPrefixes, List<Word<I>> initialSuffixes, MembershipOracle<I, D> oracle) {
        Row<I> succRow;
        if (!this.allRows.isEmpty()) {
            throw new IllegalStateException("Called initialize, but there are already rows present");
        }
        if (!GenericObservationTable.checkPrefixClosed(initialShortPrefixes)) {
            throw new IllegalArgumentException("Initial short prefixes are not prefix-closed");
        }
        if (!initialShortPrefixes.get(0).isEmpty()) {
            throw new IllegalArgumentException("First initial short prefix MUST be the empty word!");
        }
        int numSuffixes = initialSuffixes.size();
        for (Word<I> suffix : initialSuffixes) {
            if (!this.suffixSet.add(suffix)) continue;
            this.suffixes.add(suffix);
        }
        int numPrefixes = this.alphabet.size() * initialShortPrefixes.size() + 1;
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(numPrefixes * numSuffixes);
        for (Word<I> word : initialShortPrefixes) {
            this.createSpRow(word);
            GenericObservationTable.buildQueries(queries, word, this.suffixes);
        }
        for (RowImpl rowImpl : this.shortPrefixRows) {
            Word<I> word = rowImpl.getLabel();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                I sym = this.alphabet.getSymbol(i);
                Word lp = word.append(sym);
                succRow = this.rowMap.get(lp);
                if (succRow == null) {
                    succRow = this.createLpRow(lp);
                    GenericObservationTable.buildQueries(queries, lp, this.suffixes);
                }
                rowImpl.setSuccessor(i, succRow);
            }
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        for (RowImpl<I> rowImpl : this.shortPrefixRows) {
            ArrayList rowContents = new ArrayList(numSuffixes);
            GenericObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
            if (this.processContents(rowImpl, rowContents, true)) continue;
            this.initialConsistencyCheckRequired = true;
        }
        int n = this.numberOfDistinctRows();
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        for (RowImpl<I> spRow : this.shortPrefixRows) {
            for (int i = 0; i < this.alphabet.size(); ++i) {
                int id;
                succRow = spRow.getSuccessor(i);
                if (((RowImpl)succRow).isShortPrefixRow()) continue;
                ArrayList rowContents = new ArrayList(numSuffixes);
                GenericObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
                if (this.processContents((RowImpl<I>)succRow, rowContents, false)) {
                    arrayList.add(new ArrayList());
                }
                if ((id = ((RowImpl)succRow).getRowContentId()) < n) continue;
                ((List)arrayList.get(id - n)).add(succRow);
            }
        }
        return arrayList;
    }

    private static <I> boolean checkPrefixClosed(Collection<? extends Word<I>> initialShortPrefixes) {
        HashSet<Word<I>> prefixes = new HashSet<Word<I>>(initialShortPrefixes);
        for (Word<I> pref : initialShortPrefixes) {
            if (pref.isEmpty() || prefixes.contains(pref.prefix(-1))) continue;
            return false;
        }
        return true;
    }

    private RowImpl<I> createSpRow(Word<I> prefix) {
        RowImpl<I> newRow = new RowImpl<I>(prefix, this.numRows++, this.alphabet.size());
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        this.shortPrefixRows.add(newRow);
        return newRow;
    }

    private RowImpl<I> createLpRow(Word<I> prefix) {
        RowImpl<I> newRow = new RowImpl<I>(prefix, this.numRows++);
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        int idx = this.longPrefixRows.size();
        this.longPrefixRows.add(newRow);
        newRow.setLpIndex(idx);
        return newRow;
    }

    private static <I, D> void fetchResults(Iterator<DefaultQuery<I, D>> queryIt, List<D> output, int numSuffixes) {
        for (int j = 0; j < numSuffixes; ++j) {
            DefaultQuery<I, D> qry = queryIt.next();
            output.add(qry.getOutput());
        }
    }

    private boolean processContents(RowImpl<I> row, List<D> rowContents, boolean makeCanonical) {
        boolean added = false;
        int contentId = this.rowContentIds.getOrDefault(rowContents, -1);
        if (contentId == -1) {
            contentId = this.numberOfDistinctRows();
            this.rowContentIds.put(rowContents, contentId);
            this.allRowContents.add(rowContents);
            added = true;
            if (makeCanonical) {
                this.canonicalRows.add(row);
            } else {
                this.canonicalRows.add(null);
            }
        }
        row.setRowContentId(contentId);
        return added;
    }

    @Override
    public int numberOfDistinctRows() {
        return this.allRowContents.size();
    }

    @Override
    public List<List<Row<I>>> addSuffix(Word<I> suffix, MembershipOracle<I, D> oracle) {
        return this.addSuffixes(Collections.singletonList(suffix), oracle);
    }

    @Override
    public List<List<Row<I>>> addSuffixes(Collection<? extends Word<I>> newSuffixes, MembershipOracle<I, D> oracle) {
        ArrayList<Word<I>> newSuffixList = new ArrayList<Word<I>>();
        for (Word<I> suffix : newSuffixes) {
            if (!this.suffixSet.add(suffix)) continue;
            newSuffixList.add(suffix);
        }
        if (newSuffixList.isEmpty()) {
            return Collections.emptyList();
        }
        int numNewSuffixes = newSuffixList.size();
        int numSpRows = this.shortPrefixRows.size();
        int rowCount = numSpRows + this.longPrefixRows.size();
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(rowCount * numNewSuffixes);
        for (RowImpl<I> row : this.shortPrefixRows) {
            GenericObservationTable.buildQueries(queries, row.getLabel(), newSuffixList);
        }
        for (RowImpl<I> row : this.longPrefixRows) {
            GenericObservationTable.buildQueries(queries, row.getLabel(), newSuffixList);
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        int oldSuffixCount = this.suffixes.size();
        for (RowImpl<I> row : this.shortPrefixRows) {
            List<D> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                GenericObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<D> newContents = new ArrayList<D>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            GenericObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            this.processContents(row, newContents, true);
        }
        ArrayList<List<Row<I>>> unclosed = new ArrayList<List<Row<I>>>();
        numSpRows = this.numberOfDistinctRows();
        for (RowImpl<I> row : this.longPrefixRows) {
            int id;
            List<D> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                GenericObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<D> newContents = new ArrayList<D>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            GenericObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            if (this.processContents(row, newContents, false)) {
                unclosed.add(new ArrayList());
            }
            if ((id = row.getRowContentId()) < numSpRows) continue;
            ((List)unclosed.get(id - numSpRows)).add(row);
        }
        this.suffixes.addAll(newSuffixList);
        return unclosed;
    }

    @Override
    public boolean isInitialConsistencyCheckRequired() {
        return this.initialConsistencyCheckRequired;
    }

    @Override
    public List<List<Row<I>>> addShortPrefixes(List<? extends Word<I>> shortPrefixes, MembershipOracle<I, D> oracle) {
        ArrayList<Row<I>> toSpRows = new ArrayList<Row<I>>();
        for (Word<I> sp : shortPrefixes) {
            RowImpl<I> row = this.rowMap.get(sp);
            if (row != null) {
                if (row.isShortPrefixRow()) {
                    continue;
                }
            } else {
                row = this.createSpRow(sp);
            }
            toSpRows.add(row);
        }
        return this.toShortPrefixes(toSpRows, oracle);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<List<Row<I>>> toShortPrefixes(List<Row<I>> lpRows, MembershipOracle<I, D> oracle) {
        ArrayList<RowImpl<I>> freshSpRows = new ArrayList<RowImpl<I>>();
        ArrayList<RowImpl<I>> freshLpRows = new ArrayList<RowImpl<I>>();
        for (Row<I> r : lpRows) {
            RowImpl<I> row = this.allRows.get(r.getRowId());
            if (row.isShortPrefixRow()) {
                if (row.hasContents()) continue;
                freshSpRows.add(row);
            } else {
                this.makeShort(row);
                if (!row.hasContents()) {
                    freshSpRows.add(row);
                }
            }
            Word<I> prefix = row.getLabel();
            for (int i = 0; i < this.alphabet.size(); ++i) {
                void var12_19;
                I i2 = this.alphabet.getSymbol(i);
                Word<I> lp = prefix.append(i2);
                RowImpl<I> rowImpl = this.rowMap.get(lp);
                if (rowImpl == null) {
                    RowImpl<I> rowImpl2 = this.createLpRow(lp);
                    freshLpRows.add(rowImpl2);
                }
                row.setSuccessor(i, (RowImpl<I>)var12_19);
            }
        }
        int numSuffixes = this.suffixes.size();
        int numFreshRows = freshSpRows.size() + freshLpRows.size();
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(numFreshRows * numSuffixes);
        GenericObservationTable.buildRowQueries(queries, freshSpRows, this.suffixes);
        GenericObservationTable.buildRowQueries(queries, freshLpRows, this.suffixes);
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        for (RowImpl rowImpl : freshSpRows) {
            ArrayList contents = new ArrayList(numSuffixes);
            GenericObservationTable.fetchResults(queryIt, contents, numSuffixes);
            this.processContents(rowImpl, contents, true);
        }
        int numSpRows = this.numberOfDistinctRows();
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        for (RowImpl rowImpl : freshLpRows) {
            int id;
            ArrayList contents = new ArrayList(numSuffixes);
            GenericObservationTable.fetchResults(queryIt, contents, numSuffixes);
            if (this.processContents(rowImpl, contents, false)) {
                arrayList.add(new ArrayList());
            }
            if ((id = rowImpl.getRowContentId()) < numSpRows) continue;
            ((List)arrayList.get(id - numSpRows)).add(rowImpl);
        }
        return arrayList;
    }

    private void makeShort(RowImpl<I> row) {
        int cid;
        if (row.isShortPrefixRow()) {
            return;
        }
        int lastIdx = this.longPrefixRows.size() - 1;
        RowImpl<I> last = this.longPrefixRows.get(lastIdx);
        int rowIdx = row.getLpIndex();
        this.longPrefixRows.remove(lastIdx);
        if (last != row) {
            this.longPrefixRows.set(rowIdx, last);
            last.setLpIndex(rowIdx);
        }
        this.shortPrefixRows.add(row);
        row.makeShort(this.alphabet.size());
        if (row.hasContents() && this.canonicalRows.get(cid = row.getRowContentId()) == null) {
            this.canonicalRows.set(cid, row);
        }
    }

    private static <I, D> void buildRowQueries(List<DefaultQuery<I, D>> queryList, List<? extends Row<I>> rows, List<? extends Word<I>> suffixes) {
        for (Row<I> row : rows) {
            GenericObservationTable.buildQueries(queryList, row.getLabel(), suffixes);
        }
    }

    @Override
    public List<D> rowContents(Row<I> row) {
        return this.allRowContents.get(row.getRowContentId());
    }

    @Override
    public Row<I> getRow(int rowId) {
        return this.allRows.get(rowId);
    }

    @Override
    public int numberOfRows() {
        return this.shortPrefixRows.size() + this.longPrefixRows.size();
    }

    @Override
    public List<Word<I>> getSuffixes() {
        return this.suffixes;
    }

    @Override
    public boolean isInitialized() {
        return !this.allRows.isEmpty();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public Word<I> transformAccessSequence(Word<I> word) {
        Row current = this.shortPrefixRows.get(0);
        assert (current != null);
        for (I sym : word) {
            current = this.getRowSuccessor(current, sym);
            current = this.canonicalRows.get(current.getRowContentId());
            assert (current != null);
        }
        return current.getLabel();
    }

    @Override
    public boolean isAccessSequence(Word<I> word) {
        Row<I> current = this.shortPrefixRows.get(0);
        for (I sym : word) {
            if (this.isCanonical(current = this.getRowSuccessor(current, sym))) continue;
            return false;
        }
        return true;
    }

    private boolean isCanonical(Row<I> row) {
        if (!row.isShortPrefixRow()) {
            return false;
        }
        int contentId = row.getRowContentId();
        return this.canonicalRows.get(contentId) == row;
    }

    @Override
    public List<List<Row<I>>> addAlphabetSymbol(I symbol, MembershipOracle<I, D> oracle) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        int newAlphabetSize = this.alphabet.size();
        if (this.isInitialized() && this.alphabetSize < newAlphabetSize) {
            this.alphabetSize = newAlphabetSize;
            int newSymbolIdx = this.alphabet.getSymbolIndex(symbol);
            List<RowImpl<I>> shortPrefixes = this.shortPrefixRows;
            ArrayList<RowImpl<I>> newLongPrefixes = new ArrayList<RowImpl<I>>(shortPrefixes.size());
            for (RowImpl<I> prefix : shortPrefixes) {
                prefix.ensureInputCapacity(newAlphabetSize);
                Word<I> newLongPrefix = prefix.getLabel().append(symbol);
                RowImpl<I> longPrefixRow = this.createLpRow(newLongPrefix);
                newLongPrefixes.add(longPrefixRow);
                prefix.setSuccessor(newSymbolIdx, longPrefixRow);
            }
            int numLongPrefixes = newLongPrefixes.size();
            int numSuffixes = this.numberOfSuffixes();
            ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(numLongPrefixes * numSuffixes);
            GenericObservationTable.buildRowQueries(queries, newLongPrefixes, this.getSuffixes());
            oracle.processQueries(queries);
            Iterator<DefaultQuery<I, D>> queryIterator = queries.iterator();
            ArrayList<List<Row<I>>> result = new ArrayList<List<Row<I>>>(numLongPrefixes);
            for (RowImpl rowImpl : newLongPrefixes) {
                ArrayList contents = new ArrayList(numSuffixes);
                GenericObservationTable.fetchResults(queryIterator, contents, numSuffixes);
                if (!this.processContents(rowImpl, contents, false)) continue;
                result.add(Collections.singletonList(rowImpl));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Row<I>> getShortPrefixRows() {
        return Collections.unmodifiableList(this.shortPrefixRows);
    }

    @Override
    public Collection<Row<I>> getLongPrefixRows() {
        return Collections.unmodifiableList(this.longPrefixRows);
    }
}

