/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta;

import java.util.Objects;
import java.util.function.Consumer;
import net.automatalib.common.smartcollection.ArrayStorage;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBasePTAState<S extends AbstractBasePTAState<S, SP, TP>, SP, TP>
implements Cloneable {
    protected SP property;
    protected @MonotonicNonNull ArrayStorage<TP> transProperties;
    protected @MonotonicNonNull ArrayStorage<S> successors;
    protected int id = -1;

    public SP getStateProperty() {
        return this.property;
    }

    public @Nullable TP getTransProperty(int index) {
        if (this.transProperties == null) {
            return null;
        }
        return this.transProperties.get(index);
    }

    public S copy() {
        return this.copy((ArrayStorage<TP>)(this.transProperties != null ? this.transProperties.clone() : null));
    }

    public S copy(@Nullable ArrayStorage<TP> newTPs) {
        try {
            AbstractBasePTAState copy = (AbstractBasePTAState)this.clone();
            copy.transProperties = newTPs;
            if (this.successors != null) {
                copy.successors = this.successors.clone();
            }
            return (S)copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public @Nullable S getSuccessor(int index) {
        if (this.successors == null) {
            return null;
        }
        return (S)((AbstractBasePTAState)this.successors.get(index));
    }

    public void setSuccessor(int index, S succ, int alphabetSize) {
        if (this.successors == null) {
            this.successors = new ArrayStorage(alphabetSize);
        }
        this.successors.set(index, succ);
    }

    public S getOrCreateSuccessor(int index, int alphabetSize) {
        AbstractBasePTAState<S, SP, TP> succ;
        if (this.successors == null) {
            this.successors = new ArrayStorage(alphabetSize);
        }
        if ((succ = (AbstractBasePTAState)this.successors.get(index)) == null) {
            succ = this.createSuccessor(index);
            this.successors.set(index, (S)succ);
        }
        return (S)succ;
    }

    protected S createSuccessor(int index) {
        return this.createState();
    }

    protected abstract S createState();

    public void forEachSucc(Consumer<? super S> cons) {
        if (this.successors != null) {
            for (AbstractBasePTAState succ : this.successors) {
                if (succ == null) continue;
                cons.accept(succ);
            }
        }
    }

    public void mergeTransitionProperty(int index, int alphabetSize, TP newTP) {
        if (!this.tryMergeTransitionProperty(index, alphabetSize, newTP)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean tryMergeTransitionProperty(int index, int alphabetSize, TP newTP) {
        if (this.transProperties != null) {
            TP oldTp = this.transProperties.get(index);
            if (oldTp != null) {
                return Objects.equals(oldTp, newTP);
            }
        } else {
            this.transProperties = new ArrayStorage(alphabetSize);
        }
        this.transProperties.set(index, newTP);
        return true;
    }

    public void mergeStateProperty(SP newSP) {
        if (!this.tryMergeStateProperty(newSP)) {
            throw new IllegalStateException();
        }
    }

    public boolean tryMergeStateProperty(SP newSP) {
        if (this.property != null) {
            return Objects.equals(this.property, newSP);
        }
        this.property = newSP;
        return true;
    }

    public SP getProperty() {
        return this.property;
    }
}

