/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta;

import de.learnlib.datastructure.pta.AbstractBasePTAState;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PTATransition<S extends AbstractBasePTAState<S, ?, ?>> {
    private final S source;
    private final int index;

    public PTATransition(S source, @NonNegative int index) {
        this.source = (AbstractBasePTAState)Objects.requireNonNull(source);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        this.index = index;
    }

    public S getSource() {
        return this.source;
    }

    public @NonNegative int getIndex() {
        return this.index;
    }

    public @Nullable S getTarget() {
        return ((AbstractBasePTAState)this.source).getSuccessor(this.index);
    }
}

