/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.wrapper;

import de.learnlib.datastructure.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.BasePTA;
import de.learnlib.datastructure.pta.PTATransition;
import java.util.Collection;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.util.WrapperUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DFAWrapper<S extends AbstractBasePTAState<S, Boolean, Void>, I>
implements DFA<S, I>,
FiniteAlphabetAutomaton<S, I, S> {
    private final Alphabet<I> alphabet;
    private final BasePTA<S, Boolean, Void> pta;

    public DFAWrapper(Alphabet<I> alphabet, BasePTA<S, Boolean, Void> pta) {
        assert (alphabet.size() == pta.getInputAlphabet().size());
        this.alphabet = alphabet;
        this.pta = pta;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public Collection<S> getStates() {
        return this.pta.getStates();
    }

    @Override
    public @Nullable S getTransition(S state, I input) {
        PTATransition<S> t = this.pta.getTransition(state, this.alphabet.getSymbolIndex(input));
        return t == null ? null : (S)t.getTarget();
    }

    @Override
    public boolean isAccepting(S state) {
        return WrapperUtil.booleanValue(this.pta.getStateProperty(state));
    }

    @Override
    public S getInitialState() {
        return (S)this.pta.getInitialState();
    }
}

