/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.filter.cache.dfa.DFACacheOracle;
import de.learnlib.filter.cache.dfa.ProxyQuery;
import de.learnlib.filter.cache.dfa.ThreadSafeDFACacheConsistencyTest;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import net.automatalib.common.util.Pair;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;

public class ThreadSafeDFACacheOracle<I>
extends DFACacheOracle<I> {
    private final ReadWriteLock lock;

    ThreadSafeDFACacheOracle(IncrementalDFABuilder<I> incDfa, MembershipOracle<I, Boolean> delegate, ReadWriteLock lock) {
        super(incDfa, delegate);
        this.lock = lock;
    }

    @Override
    public EquivalenceOracle.DFAEquivalenceOracle<I> createCacheConsistencyTest() {
        return new ThreadSafeDFACacheConsistencyTest(super.createCacheConsistencyTest(), this.lock);
    }

    @Override
    Pair<Collection<ProxyQuery<I>>, Collection<Query<I, Boolean>>> queryCache(Collection<? extends Query<I, Boolean>> queries) {
        this.lock.readLock().lock();
        try {
            Pair pair = super.queryCache(queries);
            return pair;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    void updateCache(Collection<? extends ProxyQuery<I>> proxyQueries) {
        this.lock.writeLock().lock();
        try {
            super.updateCache(proxyQueries);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

