/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.filter.cache.dfa.ThreadSafeDFACacheOracle;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.incremental.dfa.dag.IncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.dag.IncrementalPCDFADAGBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalDFATreeBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalPCDFATreeBuilder;

public final class ThreadSafeDFACaches {
    private ThreadSafeDFACaches() {
    }

    public static <I> Supplier<ThreadSafeDFACacheOracle<I>> createCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Boolean>> oracleSupplier) {
        return ThreadSafeDFACaches.createDAGCache(alphabet, oracleSupplier);
    }

    public static <I> Collection<ThreadSafeDFACacheOracle<I>> createCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Boolean>> oracles) {
        return ThreadSafeDFACaches.createDAGCache(alphabet, oracles);
    }

    public static <I> Supplier<ThreadSafeDFACacheOracle<I>> createDAGCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Boolean>> oracleSupplier) {
        return ThreadSafeDFACaches.createSupplierBasedCache(alphabet, oracleSupplier, IncrementalDFADAGBuilder::new);
    }

    public static <I> Collection<ThreadSafeDFACacheOracle<I>> createDAGCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Boolean>> oracles) {
        return ThreadSafeDFACaches.createCollectionBasedCache(alphabet, oracles, IncrementalDFADAGBuilder::new);
    }

    public static <I> Supplier<ThreadSafeDFACacheOracle<I>> createDAGPCCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Boolean>> oracleSupplier) {
        return ThreadSafeDFACaches.createSupplierBasedCache(alphabet, oracleSupplier, IncrementalPCDFADAGBuilder::new);
    }

    public static <I> Collection<ThreadSafeDFACacheOracle<I>> createDAGPCCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Boolean>> oracles) {
        return ThreadSafeDFACaches.createCollectionBasedCache(alphabet, oracles, IncrementalPCDFADAGBuilder::new);
    }

    public static <I> Supplier<ThreadSafeDFACacheOracle<I>> createTreeCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Boolean>> oracleSupplier) {
        return ThreadSafeDFACaches.createSupplierBasedCache(alphabet, oracleSupplier, IncrementalDFATreeBuilder::new);
    }

    public static <I> Collection<ThreadSafeDFACacheOracle<I>> createTreeCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Boolean>> oracles) {
        return ThreadSafeDFACaches.createCollectionBasedCache(alphabet, oracles, IncrementalDFATreeBuilder::new);
    }

    public static <I> Supplier<ThreadSafeDFACacheOracle<I>> createTreePCCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Boolean>> oracleSupplier) {
        return ThreadSafeDFACaches.createSupplierBasedCache(alphabet, oracleSupplier, IncrementalPCDFATreeBuilder::new);
    }

    public static <I> Collection<ThreadSafeDFACacheOracle<I>> createTreePCCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Boolean>> oracles) {
        return ThreadSafeDFACaches.createCollectionBasedCache(alphabet, oracles, IncrementalPCDFATreeBuilder::new);
    }

    private static <I> Supplier<ThreadSafeDFACacheOracle<I>> createSupplierBasedCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Boolean>> oracleSupplier, Function<? super Alphabet<I>, ? extends IncrementalDFABuilder<I>> builder) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        IncrementalDFABuilder incremental = builder.apply(alphabet);
        return () -> new ThreadSafeDFACacheOracle(incremental, (MembershipOracle)oracleSupplier.get(), lock);
    }

    private static <I> Collection<ThreadSafeDFACacheOracle<I>> createCollectionBasedCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Boolean>> oracles, Function<? super Alphabet<I>, ? extends IncrementalDFABuilder<I>> builder) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        IncrementalDFABuilder<I> incremental = builder.apply(alphabet);
        ArrayList<ThreadSafeDFACacheOracle<I>> result = new ArrayList<ThreadSafeDFACacheOracle<I>>(oracles.size());
        for (MembershipOracle<I, Boolean> oracle : oracles) {
            result.add(new ThreadSafeDFACacheOracle<I>(incremental, oracle, lock));
        }
        return result;
    }
}

