/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.filter.cache.mealy.ThreadSafeMealyCacheConsistencyTest;
import de.learnlib.filter.cache.sul.StateLocalInputSULCache;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.sul.StateLocalInputSUL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.WordBuilder;

public class ThreadSafeStateLocalInputSULCache<I, O>
extends StateLocalInputSULCache<I, O> {
    ThreadSafeStateLocalInputSULCache(IncrementalMealyBuilder<I, O> incMealy, StateLocalInputSUL<I, O> sul) {
        this(new ThreadSafeStateLocalInputSULCacheImpl(incMealy, new ReentrantReadWriteLock(), incMealy.asTransitionSystem(), sul));
    }

    <S, T> ThreadSafeStateLocalInputSULCache(ThreadSafeStateLocalInputSULCacheImpl<S, I, T, O> cacheImpl) {
        super(cacheImpl);
    }

    private static final class ThreadSafeStateLocalInputSULCacheImpl<S, I, T, O>
    extends StateLocalInputSULCache.StateLocalInputSULCacheImpl<S, I, T, O> {
        private final ReadWriteLock lock;

        ThreadSafeStateLocalInputSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, StateLocalInputSUL<I, O> sul) {
            this(incMealy, lock, mealyTs, new ConcurrentHashMap(), sul);
        }

        ThreadSafeStateLocalInputSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, Map<S, Collection<I>> enabledInputCache, StateLocalInputSUL<I, O> sul) {
            super(incMealy, mealyTs, enabledInputCache, sul);
            this.lock = lock;
        }

        @Override
        public void pre() {
            this.lock.readLock().lock();
            super.pre();
        }

        @Override
        protected void requiredInitializedDelegate() {
            this.lock.readLock().unlock();
            super.requiredInitializedDelegate();
        }

        @Override
        protected void updateCache(WordBuilder<I> inputBuilder, WordBuilder<O> outputBuilder) {
            if (outputBuilder.isEmpty()) {
                this.lock.readLock().unlock();
            } else {
                this.lock.writeLock().lock();
                try {
                    super.updateCache(inputBuilder, outputBuilder);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }

        @Override
        public boolean canFork() {
            return this.delegate.canFork();
        }

        @Override
        public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
            return new ThreadSafeMealyCacheConsistencyTest(super.createCacheConsistencyTest(), this.lock);
        }

        @Override
        public StateLocalInputSUL<I, O> fork() {
            return new ThreadSafeStateLocalInputSULCacheImpl<S, I, T, O>(this.incMealy, this.lock, this.mealyTs, this.enabledInputCache, this.delegate.fork());
        }
    }
}

