/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.sba;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SBA;
import net.automatalib.util.automaton.procedural.SBAs;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimulatorEQOracle<I>
implements EquivalenceOracle<SBA<?, I>, I, Boolean> {
    private final SBA<?, I> sba;

    public SimulatorEQOracle(SBA<?, I> sba) {
        this.sba = sba;
    }

    @Override
    public @Nullable DefaultQuery<I, Boolean> findCounterExample(SBA<?, I> hypothesis, Collection<? extends I> inputs) {
        if (!(inputs instanceof ProceduralInputAlphabet)) {
            throw new IllegalArgumentException("Inputs are not an SPA alphabet");
        }
        ProceduralInputAlphabet alphabet = (ProceduralInputAlphabet)inputs;
        Word<I> sep = SBAs.findSeparatingWord(this.sba, hypothesis, alphabet);
        if (sep == null) {
            return null;
        }
        return new DefaultQuery<I, Object>(sep, this.sba.computeOutput((Iterable)sep));
    }
}

