/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.oracle.SymbolQueryOracle;
import de.learnlib.sul.SUL;

public class SULSymbolQueryOracle<I, O>
implements SymbolQueryOracle<I, O> {
    private final SUL<I, O> sul;
    private boolean preRequired;
    private boolean postRequired;

    public SULSymbolQueryOracle(SUL<I, O> sul) {
        this.sul = sul;
        this.preRequired = true;
    }

    @Override
    public O query(I i) {
        if (this.preRequired) {
            this.sul.pre();
            this.preRequired = false;
            this.postRequired = true;
        }
        return this.queryInternal(i);
    }

    @Override
    public void reset() {
        if (this.postRequired) {
            this.sul.post();
            this.postRequired = false;
        }
        this.preRequired = true;
    }

    protected O queryInternal(I i) {
        return this.sul.step(i);
    }
}

