/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.parallelism;

import com.google.common.base.Preconditions;
import de.learnlib.oracle.parallelism.AbstractDynamicBatchProcessor;
import de.learnlib.oracle.parallelism.BatchProcessor;
import de.learnlib.oracle.parallelism.ThreadPool;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.automatalib.common.util.concurrent.ScalingThreadPoolExecutor;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractDynamicBatchProcessorBuilder<Q, P extends BatchProcessor<Q>, OR> {
    private static final int DEFAULT_KEEP_ALIVE_TIME = 60;
    private final @Nullable Supplier<? extends P> oracleSupplier;
    private final @Nullable Collection<? extends P> oracles;
    private ExecutorService customExecutor;
    private @NonNegative int batchSize = AbstractDynamicBatchProcessor.BATCH_SIZE;
    private @NonNegative int poolSize = AbstractDynamicBatchProcessor.POOL_SIZE;
    private ThreadPool.PoolPolicy poolPolicy = AbstractDynamicBatchProcessor.POOL_POLICY;

    public AbstractDynamicBatchProcessorBuilder(Supplier<? extends P> oracleSupplier) {
        this.oracleSupplier = oracleSupplier;
        this.oracles = null;
    }

    public AbstractDynamicBatchProcessorBuilder(Collection<? extends P> oracles) {
        Preconditions.checkArgument(!oracles.isEmpty(), "No oracles specified");
        this.oracles = oracles;
        this.oracleSupplier = null;
    }

    public AbstractDynamicBatchProcessorBuilder<Q, P, OR> withCustomExecutor(ExecutorService executor) {
        this.customExecutor = executor;
        return this;
    }

    public AbstractDynamicBatchProcessorBuilder<Q, P, OR> withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public AbstractDynamicBatchProcessorBuilder<Q, P, OR> withPoolSize(@NonNegative int poolSize) {
        this.poolSize = poolSize;
        return this;
    }

    public AbstractDynamicBatchProcessorBuilder<Q, P, OR> withPoolPolicy(ThreadPool.PoolPolicy policy) {
        this.poolPolicy = policy;
        return this;
    }

    public OR create() {
        Supplier<? extends P> supplier;
        ExecutorService executor;
        if (this.oracles != null) {
            executor = Executors.newFixedThreadPool(this.oracles.size());
            supplier = new StaticOracleProvider<P>(this.oracles);
        } else if (this.customExecutor != null) {
            executor = this.customExecutor;
            supplier = this.oracleSupplier;
        } else {
            switch (this.poolPolicy) {
                case FIXED: {
                    executor = Executors.newFixedThreadPool(this.poolSize);
                    break;
                }
                case CACHED: {
                    executor = new ScalingThreadPoolExecutor(0, this.poolSize, 60L, TimeUnit.SECONDS);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown pool policy: " + (Object)((Object)this.poolPolicy));
                }
            }
            supplier = this.oracleSupplier;
        }
        return this.buildOracle(supplier, this.batchSize, executor);
    }

    protected abstract OR buildOracle(Supplier<? extends P> var1, int var2, ExecutorService var3);

    static class StaticOracleProvider<P extends BatchProcessor<?>>
    implements Supplier<P> {
        private final P[] oracles;
        private int idx;

        StaticOracleProvider(P[] oracles) {
            this.oracles = oracles;
        }

        StaticOracleProvider(Collection<? extends P> oracles) {
            this.oracles = oracles.toArray(new BatchProcessor[oracles.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public P get() {
            StaticOracleProvider staticOracleProvider = this;
            synchronized (staticOracleProvider) {
                if (this.idx < this.oracles.length) {
                    return this.oracles[this.idx++];
                }
            }
            throw new IllegalStateException("The supplier should not have been called more than " + this.oracles.length + " times");
        }
    }
}

