/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.parallelism;

import com.google.common.base.Preconditions;
import de.learnlib.oracle.parallelism.AbstractStaticBatchProcessor;
import de.learnlib.oracle.parallelism.BatchProcessor;
import de.learnlib.oracle.parallelism.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractStaticBatchProcessorBuilder<Q, P extends BatchProcessor<Q>, OR> {
    private final @Nullable Collection<? extends P> oracles;
    private final @Nullable Supplier<? extends P> oracleSupplier;
    private @NonNegative int minBatchSize = AbstractStaticBatchProcessor.MIN_BATCH_SIZE;
    private @NonNegative int numInstances = AbstractStaticBatchProcessor.NUM_INSTANCES;
    private ThreadPool.PoolPolicy poolPolicy = AbstractStaticBatchProcessor.POOL_POLICY;

    public AbstractStaticBatchProcessorBuilder(Collection<? extends P> oracles) {
        Preconditions.checkArgument(!oracles.isEmpty(), "No oracles specified");
        this.oracles = oracles;
        this.oracleSupplier = null;
    }

    public AbstractStaticBatchProcessorBuilder(Supplier<? extends P> oracleSupplier) {
        this.oracles = null;
        this.oracleSupplier = oracleSupplier;
    }

    public AbstractStaticBatchProcessorBuilder<Q, P, OR> withMinBatchSize(@NonNegative int minBatchSize) {
        this.minBatchSize = minBatchSize;
        return this;
    }

    public AbstractStaticBatchProcessorBuilder<Q, P, OR> withPoolPolicy(ThreadPool.PoolPolicy policy) {
        this.poolPolicy = policy;
        return this;
    }

    public AbstractStaticBatchProcessorBuilder<Q, P, OR> withNumInstances(@NonNegative int numInstances) {
        this.numInstances = numInstances;
        return this;
    }

    public OR create() {
        Collection<? extends P> oracleInstances;
        if (this.oracles != null) {
            oracleInstances = this.oracles;
        } else {
            ArrayList<P> oracleList = new ArrayList<P>(this.numInstances);
            for (int i = 0; i < this.numInstances; ++i) {
                oracleList.add((BatchProcessor)this.oracleSupplier.get());
            }
            oracleInstances = oracleList;
        }
        return this.buildOracle(oracleInstances, this.minBatchSize, this.poolPolicy);
    }

    protected abstract OR buildOracle(Collection<? extends P> var1, int var2, ThreadPool.PoolPolicy var3);
}

