/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util;

import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.OmegaQueryAnswerer;
import de.learnlib.oracle.QueryAnswerer;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.OmegaQuery;
import de.learnlib.query.Query;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MQUtil {
    private MQUtil() {
    }

    public static <I, D> DefaultQuery<I, D> normalize(MembershipOracle<I, D> oracle, DefaultQuery<I, D> query) {
        if (query.isNormalized()) {
            return query;
        }
        return MQUtil.query(oracle, Word.epsilon(), query.getInput());
    }

    public static <I, D> DefaultQuery<I, D> query(MembershipOracle<I, D> oracle, Word<I> prefix, Word<I> suffix) {
        DefaultQuery<I, Word<I>> qry = new DefaultQuery<I, Word<I>>(prefix, suffix);
        oracle.processQuery(qry);
        return qry;
    }

    public static <I, D> DefaultQuery<I, D> query(MembershipOracle<I, D> oracle, Word<I> queryWord) {
        return MQUtil.query(oracle, Word.epsilon(), queryWord);
    }

    public static <I, D> void answerQueries(QueryAnswerer<I, D> answerer, Collection<? extends Query<I, D>> queries) {
        for (Query<I, D> query : queries) {
            Word<I> prefix = query.getPrefix();
            Word<I> suffix = query.getSuffix();
            D answer = answerer.answerQuery(prefix, suffix);
            query.answer(answer);
        }
    }

    public static <S, I, D> void answerOmegaQueries(OmegaQueryAnswerer<S, I, D> answerer, Collection<? extends OmegaQuery<I, D>> queries) {
        for (OmegaQuery<I, D> query : queries) {
            Word<I> prefix = query.getPrefix();
            Word<I> loop = query.getLoop();
            int repeat = query.getRepeat();
            Pair<@Nullable D, Integer> answer = answerer.answerQuery(prefix, loop, repeat);
            query.answer(answer.getFirst(), answer.getSecond());
        }
    }

    public static <I, D> boolean isCounterexample(DefaultQuery<I, D> query, SuffixOutput<I, D> hyp) {
        D hypOut;
        D qryOut = query.getOutput();
        return !Objects.equals(qryOut, hypOut = hyp.computeSuffixOutput(query.getPrefix(), query.getSuffix()));
    }
}

