/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.mealy.MealyLearnerWrapper;
import de.learnlib.util.mealy.SymbolOracleWrapper;
import java.util.Iterator;
import java.util.Objects;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MealyUtil {
    public static final int NO_MISMATCH = -1;

    private MealyUtil() {
    }

    public static <I, O> int findMismatch(MealyMachine<?, I, ?, O> hypothesis, Word<I> input, Word<O> output) {
        return MealyUtil.doFindMismatch(hypothesis, input, output);
    }

    public static <O> int findMismatch(Word<O> out1, Word<O> out2) {
        int len = out1.length();
        assert (len == out2.length());
        for (int i = 0; i < len; ++i) {
            O sym2;
            O sym1 = out1.getSymbol(i);
            if (Objects.equals(sym1, sym2 = out2.getSymbol(i))) continue;
            return i;
        }
        return -1;
    }

    private static <S, I, T, O> int doFindMismatch(MealyMachine<S, I, T, O> hypothesis, Word<I> input, Word<O> output) {
        Object state = hypothesis.getInitialState();
        if (state == null) {
            return -1;
        }
        Iterator<I> inIt = input.iterator();
        Iterator<O> outIt = output.iterator();
        int i = 0;
        while (inIt.hasNext() && outIt.hasNext()) {
            Object trans = hypothesis.getTransition(state, inIt.next());
            if (trans == null) {
                return -1;
            }
            O ceOut = outIt.next();
            Object transOut = hypothesis.getTransitionOutput(trans);
            if (!Objects.equals(transOut, ceOut)) {
                return i;
            }
            state = hypothesis.getSuccessor(trans);
            ++i;
        }
        return -1;
    }

    public static <I, O> @Nullable DefaultQuery<I, Word<O>> shortenCounterExample(MealyMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput(cePrefix, ceSuffix);
        Word<O> ceOut = ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MealyUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx + 1), ceOut.prefix(mismatchIdx + 1));
    }

    public static <I, O> @Nullable DefaultQuery<I, O> reduceCounterExample(MealyMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput(cePrefix, ceSuffix);
        Word<O> ceOut = ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MealyUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx + 1), ceOut.getSymbol(mismatchIdx));
    }

    public static <M extends MealyMachine<?, I, ?, O>, I, O> LearningAlgorithm.MealyLearner<I, O> wrapSymbolLearner(LearningAlgorithm<M, I, O> learner) {
        return new MealyLearnerWrapper<M, I, O>(learner);
    }

    public static <I, O> MembershipOracle<I, @Nullable O> wrapWordOracle(MembershipOracle<I, Word<O>> oracle) {
        return new SymbolOracleWrapper<I, O>(oracle);
    }
}

