/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SymbolOracleWrapper<I, O>
implements MembershipOracle<I, O> {
    private final MembershipOracle<I, Word<O>> wordOracle;

    SymbolOracleWrapper(MembershipOracle<I, Word<O>> wordOracle) {
        this.wordOracle = wordOracle;
    }

    @Override
    public void processQueries(Collection<? extends Query<I, @Nullable O>> queries) {
        ArrayList<LastSymbolQuery<I, O>> lsQueries = new ArrayList<LastSymbolQuery<I, O>>(queries.size());
        for (Query<I, O> qry : queries) {
            lsQueries.add(new LastSymbolQuery<I, O>(qry));
        }
        this.wordOracle.processQueries(lsQueries);
    }

    private static final class LastSymbolQuery<I, O>
    extends Query<I, Word<O>> {
        private final Query<I, @Nullable O> originalQuery;

        LastSymbolQuery(Query<I, @Nullable O> originalQuery) {
            this.originalQuery = originalQuery;
        }

        @Override
        public void answer(Word<O> output) {
            this.originalQuery.answer(output.isEmpty() ? null : (Object)output.lastSymbol());
        }

        @Override
        public Word<I> getPrefix() {
            return this.originalQuery.getPrefix();
        }

        @Override
        public Word<I> getSuffix() {
            return this.originalQuery.getSuffix();
        }

        @Override
        public String toString() {
            return this.originalQuery.toString();
        }
    }
}

