/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Component;
import java.awt.geom.Point2D;

public class MagnifyTransformer
extends LensTransformer
implements MutableTransformer {
    public MagnifyTransformer(Component component) {
        this(component, new MutableAffineTransformer());
    }

    public MagnifyTransformer(Component component, MutableTransformer delegate) {
        super(component, delegate);
        this.magnification = 3.0f;
    }

    @Override
    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        Point2D viewPoint = this.delegate.transform(graphPoint);
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar(pointFromCenter);
        double theta = polar.getTheta();
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return viewPoint;
        }
        double mag = this.magnification;
        radius *= mag;
        radius = Math.min(radius, viewRadius);
        Point2D projectedPoint = PolarPoint.polarToCartesian(theta, radius);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return translatedBack;
    }

    @Override
    public Point2D inverseTransform(Point2D viewPoint) {
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar(pointFromCenter);
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return this.delegate.inverseTransform(viewPoint);
        }
        double mag = this.magnification;
        polar.setRadius(radius /= mag);
        Point2D projectedPoint = PolarPoint.polarToCartesian(polar);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return this.delegate.inverseTransform(translatedBack);
    }

    public Point2D magnify(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.getViewCenter();
        double ratio = this.getRatio();
        Point2D viewPoint = graphPoint;
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = PolarPoint.cartesianToPolar(pointFromCenter);
        double theta = polar.getTheta();
        double radius = polar.getRadius();
        double mag = this.magnification;
        Point2D projectedPoint = PolarPoint.polarToCartesian(theta, radius *= mag);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return translatedBack;
    }
}

