/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.ShapeFlatnessTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class TransformingGraphics
extends GraphicsDecorator {
    protected BidirectionalTransformer transformer;

    public TransformingGraphics(BidirectionalTransformer transformer) {
        this(transformer, null);
    }

    public TransformingGraphics(BidirectionalTransformer Function2, Graphics2D delegate) {
        super(delegate);
        this.transformer = Function2;
    }

    public BidirectionalTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(BidirectionalTransformer Function2) {
        this.transformer = Function2;
    }

    @Override
    public void draw(Shape s2) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s2);
        this.delegate.draw(shape);
    }

    public void draw(Shape s2, float flatness) {
        Shape shape = null;
        shape = this.transformer instanceof ShapeFlatnessTransformer ? ((ShapeFlatnessTransformer)this.transformer).transform(s2, flatness) : ((ShapeTransformer)this.transformer).transform(s2);
        this.delegate.draw(shape);
    }

    @Override
    public void fill(Shape s2) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s2);
        this.delegate.fill(shape);
    }

    public void fill(Shape s2, float flatness) {
        Shape shape = null;
        shape = this.transformer instanceof ShapeFlatnessTransformer ? ((ShapeFlatnessTransformer)this.transformer).transform(s2, flatness) : ((ShapeTransformer)this.transformer).transform(s2);
        this.delegate.fill(shape);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        Image image = null;
        if (this.transformer instanceof ShapeFlatnessTransformer) {
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, img.getWidth(observer), img.getHeight(observer));
            Rectangle2D s2 = ((ShapeTransformer)this.transformer).transform(r).getBounds2D();
            image = img.getScaledInstance((int)s2.getWidth(), (int)s2.getHeight(), 4);
            x = (int)s2.getMinX();
            y = (int)s2.getMinY();
        } else {
            image = img;
        }
        return this.delegate.drawImage(image, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform at, ImageObserver observer) {
        Image image = null;
        int x = (int)at.getTranslateX();
        int y = (int)at.getTranslateY();
        if (this.transformer instanceof ShapeFlatnessTransformer) {
            Rectangle2D.Double r = new Rectangle2D.Double(x, y, img.getWidth(observer), img.getHeight(observer));
            Rectangle2D s2 = ((ShapeTransformer)this.transformer).transform(r).getBounds2D();
            image = img.getScaledInstance((int)s2.getWidth(), (int)s2.getHeight(), 4);
            x = (int)s2.getMinX();
            y = (int)s2.getMinY();
            at.setToTranslation(s2.getMinX(), s2.getMinY());
        } else {
            image = img;
        }
        return this.delegate.drawImage(image, at, observer);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s2, boolean onStroke) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s2);
        return this.delegate.hit(rect, shape, onStroke);
    }

    @Override
    public Graphics create() {
        return this.delegate.create();
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }
}

