/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.codegenerator;

import com.google.common.collect.Lists;
import info.scce.addlib.codegenerator.CodeGenerator;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.layouter.DotLayouter;
import info.scce.addlib.layouter.Layouter;
import info.scce.addlib.traverser.PreorderIterator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class AsciiArtGenerator<D extends RegularDD<?, D>>
extends CodeGenerator<D> {
    public static final int TRANSFORMATION_FACTOR_Y = 10;
    public static final int TRANSFORMATION_FACTOR_X = 20;
    private final Layouter<D> layouter = new DotLayouter();
    private List<List<Character>> table;

    public AsciiArtGenerator() {
        this.layouter.setTransformationY(10.0, 0.0);
        this.layouter.setTransformationX(20.0, 0.0);
    }

    @Override
    public void generate(PrintWriter out, List<LabelledRegularDD<D>> roots) {
        D root = roots.get(0).dd();
        this.layouter.layout(root);
        this.table = new ArrayList<List<Character>>();
        this.addNodesToList(root);
        this.calculateEdges(root);
        this.drawTable(out);
    }

    private void addNodesToList(D root) {
        PreorderIterator<D> iterator = new PreorderIterator<D>(root);
        while (iterator.hasNext()) {
            RegularDD current = (RegularDD)iterator.next();
            int y = (int)this.layouter.y(current);
            int x = (int)this.layouter.x(current);
            String label = current.isConstant() ? current.toString() : current.readName();
            while (this.table.size() <= y) {
                this.table.add(new ArrayList());
            }
            while (this.table.get(y).size() < x + label.length()) {
                this.table.get(y).add(Character.valueOf(' '));
            }
            int i = 0;
            for (char c : label.toCharArray()) {
                this.table.get(y).set(x + i, Character.valueOf(c));
                ++i;
            }
        }
    }

    private void calculateEdges(D root) {
        PreorderIterator<D> iterator = new PreorderIterator<D>(root);
        while (iterator.hasNext()) {
            RegularDD current = (RegularDD)iterator.next();
            if (current.isConstant()) continue;
            this.addEdgeToTable(this.newEdge(current, (RegularDD)current.t(), true));
            this.addEdgeToTable(this.newEdge(current, (RegularDD)current.e(), false));
            this.calculateEdges((RegularDD)current.t());
            this.calculateEdges((RegularDD)current.e());
        }
    }

    private Edge newEdge(D from, D to, boolean t) {
        int startX = (int)this.layouter.x(from);
        int startY = (int)this.layouter.y(from);
        int endX = (int)this.layouter.x(to);
        int endY = (int)this.layouter.y(to);
        return new Edge(startX, startY, endX, endY, t);
    }

    private void addEdgeToTable(Edge edge) {
        double slope = 10000.0;
        if (edge.x1 - edge.x0 != 0) {
            slope = (double)Math.abs(edge.y1 - edge.y0) / (double)(edge.x1 - edge.x0);
        }
        char line = this.calculateSlopeChar(slope, edge.type);
        int diffY = edge.y1 - edge.y0;
        if (Math.abs(diffY) > 2) {
            int startY = edge.y0 - 1;
            int endY = edge.y1;
            diffY = endY - startY;
            double j = edge.x0;
            for (int i = 0; i > diffY; --i) {
                j += 1.0 / slope;
                while ((double)this.table.get(startY + i).size() <= j) {
                    this.table.get(startY + i).add(Character.valueOf(' '));
                }
                this.table.get(startY + i).set((int)j, Character.valueOf(line));
            }
        }
    }

    private char calculateSlopeChar(double slope, boolean type) {
        int line;
        if (type) {
            int n = slope == 0.0 ? 45 : (line = slope > 0.0 ? 92 : 47);
            if (Math.abs(slope) >= 100.0) {
                line = 124;
            }
        } else {
            int n = slope == 0.0 ? 126 : (line = slope > 0.0 ? 96 : 180);
            if (Math.abs(slope) >= 100.0) {
                line = 58;
            }
        }
        return (char)line;
    }

    private void drawTable(PrintWriter out) {
        for (List<Character> row : Lists.reverse(this.table)) {
            for (char c : row) {
                out.print(c);
            }
            out.println();
        }
        out.println();
    }

    private class Edge {
        private final int x0;
        private final int y0;
        private final int x1;
        private final int y1;
        private final boolean type;

        Edge(int x0, int y0, int x1, int y1, boolean type) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.type = type;
        }
    }
}

