/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.AbstractAlphabet;
import net.automatalib.alphabet.AbstractVPAlphabet;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.alphabet.VPSym;

public class GrowingVPAlphabet<I>
extends AbstractVPAlphabet<VPSym<I>>
implements VPAlphabet<VPSym<I>> {
    private final List<VPSym<I>> allSyms;
    private final List<VPSym<I>> callSyms;
    private final List<VPSym<I>> internalSyms;
    private final List<VPSym<I>> returnSyms;

    public GrowingVPAlphabet() {
        this(new ArrayList<VPSym<I>>(), new ArrayList<VPSym<I>>(), new ArrayList<VPSym<I>>());
    }

    private GrowingVPAlphabet(List<VPSym<I>> internalSyms, List<VPSym<I>> callSyms, List<VPSym<I>> returnSyms) {
        super(new AlphabetView<I>(internalSyms), new AlphabetView<I>(callSyms), new AlphabetView<I>(returnSyms));
        this.internalSyms = internalSyms;
        this.callSyms = callSyms;
        this.returnSyms = returnSyms;
        this.allSyms = new ArrayList<VPSym<I>>();
    }

    public VPSym<I> addNewSymbol(I userObject, VPAlphabet.SymbolType type) {
        List<VPSym<I>> localList;
        switch (type) {
            case CALL: {
                localList = this.callSyms;
                break;
            }
            case RETURN: {
                localList = this.returnSyms;
                break;
            }
            default: {
                localList = this.internalSyms;
            }
        }
        VPSym<I> vpSym = new VPSym<I>(userObject, type, localList.size(), this.allSyms.size());
        this.allSyms.add(vpSym);
        localList.add(vpSym);
        return vpSym;
    }

    @Override
    public VPAlphabet.SymbolType getSymbolType(VPSym<I> symbol) {
        return symbol.getType();
    }

    @Override
    public int size() {
        return this.allSyms.size();
    }

    @Override
    public VPSym<I> getSymbol(int index) {
        return this.allSyms.get(index);
    }

    @Override
    public int getSymbolIndex(VPSym<I> symbol) {
        if (!this.containsSymbol(symbol)) {
            throw new IllegalArgumentException();
        }
        return symbol.getGlobalIndex();
    }

    @Override
    public boolean containsSymbol(VPSym<I> symbol) {
        int idx = symbol.getGlobalIndex();
        return idx < this.allSyms.size() && this.allSyms.get(idx) == symbol;
    }

    private static class AlphabetView<I>
    extends AbstractAlphabet<VPSym<I>>
    implements Alphabet<VPSym<I>> {
        private final List<VPSym<I>> list;

        AlphabetView(List<VPSym<I>> list) {
            this.list = list;
        }

        @Override
        public VPSym<I> getSymbol(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSymbolIndex(VPSym<I> symbol) {
            if (!this.containsSymbol(symbol)) {
                throw new IllegalArgumentException();
            }
            return symbol.getLocalIndex();
        }

        @Override
        public boolean containsSymbol(VPSym<I> symbol) {
            int idx = symbol.getLocalIndex();
            return idx < this.list.size() && this.list.get(idx) == symbol;
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

