/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;

public interface VPAlphabet<I>
extends Alphabet<I> {
    public Alphabet<I> getCallAlphabet();

    public I getCallSymbol(int var1);

    public int getCallSymbolIndex(I var1);

    public int getNumCalls();

    public Alphabet<I> getInternalAlphabet();

    public I getInternalSymbol(int var1);

    public int getInternalSymbolIndex(I var1);

    public int getNumInternals();

    public Alphabet<I> getReturnAlphabet();

    public I getReturnSymbol(int var1);

    public int getReturnSymbolIndex(I var1);

    public int getNumReturns();

    public SymbolType getSymbolType(I var1);

    default public boolean isCallSymbol(I symbol) {
        return this.getSymbolType(symbol) == SymbolType.CALL;
    }

    default public boolean isInternalSymbol(I symbol) {
        return this.getSymbolType(symbol) == SymbolType.INTERNAL;
    }

    default public boolean isReturnSymbol(I symbol) {
        return this.getSymbolType(symbol) == SymbolType.RETURN;
    }

    default public int callReturnBalance(Word<I> word) {
        int crb = 0;
        for (I sym : word) {
            switch (this.getSymbolType(sym)) {
                case CALL: {
                    ++crb;
                    break;
                }
                case RETURN: {
                    --crb;
                    break;
                }
            }
        }
        return crb;
    }

    default public boolean isCallMatched(Word<I> word) {
        int crb = 0;
        for (I sym : word) {
            switch (this.getSymbolType(sym)) {
                case CALL: {
                    ++crb;
                    break;
                }
                case RETURN: {
                    if (crb <= 0) break;
                    --crb;
                    break;
                }
            }
        }
        return crb == 0;
    }

    default public boolean isReturnMatched(Word<I> word) {
        int crb = 0;
        for (I sym : word) {
            switch (this.getSymbolType(sym)) {
                case CALL: {
                    ++crb;
                    break;
                }
                case RETURN: {
                    if (--crb >= 0) break;
                    return false;
                }
            }
        }
        return true;
    }

    default public boolean isWellMatched(Word<I> word) {
        int crb = 0;
        for (I sym : word) {
            switch (this.getSymbolType(sym)) {
                case CALL: {
                    ++crb;
                    break;
                }
                case RETURN: {
                    if (--crb >= 0) break;
                    return false;
                }
            }
        }
        return crb == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Word<I> longestWellMatchedPrefix(Word<I> word) {
        int idx = 0;
        int len = word.length();
        int crb = 0;
        int lastzero = 0;
        while (idx < len) {
            I sym = word.getSymbol(idx);
            switch (this.getSymbolType(sym)) {
                case CALL: {
                    ++crb;
                    break;
                }
                case RETURN: {
                    if (--crb >= 0) break;
                    return word.prefix(lastzero);
                }
            }
            if (crb == 0) {
                lastzero = idx + 1;
            }
            ++idx;
        }
        return word.prefix(lastzero);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Word<I> longestWellMatchedSuffix(Word<I> word) {
        int idx = word.length();
        int crb = 0;
        int lastZero = idx;
        while (idx > 0) {
            I sym = word.getSymbol(--idx);
            switch (this.getSymbolType(sym)) {
                case CALL: {
                    if (++crb <= 0) break;
                    return word.subWord(lastZero);
                }
                case RETURN: {
                    --crb;
                }
            }
            if (crb != 0) continue;
            lastZero = idx;
        }
        return word.subWord(lastZero);
    }

    public static enum SymbolType {
        CALL,
        INTERNAL,
        RETURN;

    }
}

