/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.graph;

import java.util.Objects;
import net.automatalib.ts.UniversalTransitionSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TransitionEdge<I, T> {
    private final I input;
    private final T transition;

    public TransitionEdge(I input, T transition) {
        this.input = input;
        this.transition = transition;
    }

    public I getInput() {
        return this.input;
    }

    public T getTransition() {
        return this.transition;
    }

    public <TP> Property<I, TP> property(UniversalTransitionSystem<?, ?, T, ?, TP> uts) {
        return new Property<I, TP>(this.input, uts.getTransitionProperty(this.transition));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransitionEdge)) {
            return false;
        }
        TransitionEdge that = (TransitionEdge)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.transition, that.transition);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.input);
        result = 31 * result + Objects.hashCode(this.transition);
        return result;
    }

    public static final class Property<I, TP> {
        private final I input;
        private final TP property;

        public Property(I input, TP property) {
            this.input = input;
            this.property = property;
        }

        public I getInput() {
            return this.input;
        }

        public TP getProperty() {
            return this.property;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property that = (Property)o;
            return Objects.equals(this.input, that.input) && Objects.equals(this.property, that.property);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.input);
            result = 31 * result + Objects.hashCode(this.property);
            return result;
        }
    }
}

