/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.visualization.ProceduralVisualizationHelper;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.Triple;
import net.automatalib.graph.Graph;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProceduralGraphView<S, I>
implements Graph<Pair<I, S>, Triple<I, I, S>> {
    private final Alphabet<I> internalAlphabet;
    private final Collection<I> proceduralAlphabet;
    private final Map<I, UniversalDeterministicAutomaton<S, I, ?, ?, ?>> subModels;

    public ProceduralGraphView(Alphabet<I> internalAlphabet, Collection<I> proceduralAlphabet, Map<I, ? extends UniversalDeterministicAutomaton<? extends S, I, ?, ?, ?>> subModels) {
        this.internalAlphabet = internalAlphabet;
        this.proceduralAlphabet = proceduralAlphabet;
        this.subModels = subModels;
    }

    @Override
    public Collection<Pair<I, S>> getNodes() {
        ArrayList<Pair<I, S>> result = new ArrayList<Pair<I, S>>();
        for (Map.Entry<I, UniversalDeterministicAutomaton<S, I, ?, ?, ?>> e : this.subModels.entrySet()) {
            I procedure = e.getKey();
            for (Object s2 : e.getValue()) {
                result.add(Pair.of(procedure, s2));
            }
        }
        return result;
    }

    @Override
    public Collection<Triple<I, I, S>> getOutgoingEdges(Pair<I, S> node) {
        I procedure = node.getFirst();
        S state = node.getSecond();
        @NonNull UniversalDeterministicAutomaton<S, I, ?, ?, ?> subModel = this.subModels.get(procedure);
        ArrayList<Triple<I, I, S>> result = new ArrayList<Triple<I, I, S>>(this.proceduralAlphabet.size());
        for (I i : this.proceduralAlphabet) {
            S next = subModel.getSuccessor(state, i);
            if (next == null) continue;
            result.add(Triple.of(procedure, i, next));
        }
        return result;
    }

    @Override
    public Pair<I, S> getTarget(Triple<I, I, S> edge) {
        return Pair.of(edge.getFirst(), edge.getThird());
    }

    @Override
    public VisualizationHelper<Pair<I, S>, Triple<I, I, S>> getVisualizationHelper() {
        return new ProceduralVisualizationHelper<S, I>(this.internalAlphabet, this.subModels);
    }
}

