/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.array;

import java.util.Arrays;
import net.automatalib.common.smartcollection.ArrayWritable;

public final class AWUtil {
    private AWUtil() {
    }

    public static <T, U extends T> int safeWrite(ArrayWritable<U> aw, T[] array) {
        int num = aw.size();
        if (num <= 0) {
            return 0;
        }
        if (num > array.length) {
            num = array.length;
        }
        aw.writeToArray(0, array, 0, num);
        return num;
    }

    public static <T, U extends T> int safeWrite(int num, ArrayWritable<U> aw, T[] array) {
        int elementsToCopy = Math.min(num, Math.min(aw.size(), array.length));
        if (elementsToCopy <= 0) {
            return 0;
        }
        aw.writeToArray(0, array, 0, elementsToCopy);
        return elementsToCopy;
    }

    public static <T, U extends T> int safeWrite(int num, ArrayWritable<U> aw, int ofs, T[] array, int tgtOfs) {
        int arrayBound;
        int awBound = Math.min(num + ofs, aw.size());
        int elementsToCopy = Math.min(awBound, arrayBound = Math.min(num + tgtOfs, array.length));
        if (elementsToCopy <= 0) {
            return 0;
        }
        aw.writeToArray(ofs, array, tgtOfs, elementsToCopy);
        return elementsToCopy;
    }

    public static <T, U extends T> int safeWrite(ArrayWritable<U> aw, T[] array, int tgtOfs) {
        return AWUtil.safeWrite(aw.size(), aw, 0, array, tgtOfs);
    }

    public static Object[] toArray(ArrayWritable<?> aw) {
        int num = aw.size();
        Object[] arr = new Object[num];
        aw.writeToArray(0, arr, 0, num);
        return arr;
    }

    public static <T> T[] toArray(ArrayWritable<?> aw, T[] arr) {
        int num = aw.size();
        Object[] targetArray = arr.length < num ? Arrays.copyOf(arr, num) : arr;
        aw.writeToArray(0, targetArray, 0, num);
        return targetArray;
    }
}

