/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.dag;

import java.util.Arrays;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.incremental.mealy.dag.State;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StateSignature<O> {
    final ResizingArrayStorage<State<O>> successors;
    final ResizingArrayStorage<O> outputs;
    private int hashCode;

    StateSignature(int numSuccs) {
        this.successors = new ResizingArrayStorage<State>(State.class, numSuccs);
        this.outputs = new ResizingArrayStorage<Object>(Object.class, numSuccs);
        this.updateHashCode();
    }

    StateSignature(StateSignature<O> other) {
        this.successors = new ResizingArrayStorage<State<O>>(other.successors);
        this.outputs = new ResizingArrayStorage<O>(other.outputs);
        this.updateHashCode();
    }

    StateSignature<O> duplicate() {
        return new StateSignature<O>(this);
    }

    void updateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.outputs.array);
        this.hashCode = result = 31 * result + Arrays.hashCode(this.successors.array);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateSignature)) {
            return false;
        }
        StateSignature other = (StateSignature)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.outputs.array, other.outputs.array) && Arrays.equals(this.successors.array, other.successors.array);
    }
}

