/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.formula;

import java.io.IOException;
import net.automatalib.modelchecker.m3c.formula.AbstractFormulaNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBinaryFormulaNode<L, AP>
extends AbstractFormulaNode<L, AP> {
    private final FormulaNode<L, AP> leftChild;
    private final FormulaNode<L, AP> rightChild;

    public AbstractBinaryFormulaNode(FormulaNode<L, AP> leftChild, FormulaNode<L, AP> rightChild) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    public FormulaNode<L, AP> getRightChild() {
        return this.rightChild;
    }

    public int getVarNumberRight() {
        return this.rightChild.getVarNumber();
    }

    public FormulaNode<L, AP> getLeftChild() {
        return this.leftChild;
    }

    public int getVarNumberLeft() {
        return this.leftChild.getVarNumber();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractBinaryFormulaNode that = (AbstractBinaryFormulaNode)o;
        return this.leftChild.equals(that.leftChild) && this.rightChild.equals(that.rightChild);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.leftChild.hashCode();
        result = 31 * result + this.rightChild.hashCode();
        return result;
    }

    protected void printBinaryFormulaNode(Appendable a, String operator) throws IOException {
        a.append('(');
        this.getLeftChild().print(a);
        a.append(' ');
        a.append(operator);
        a.append(' ');
        this.getRightChild().print(a);
        a.append(')');
    }

    protected void printUntilNode(Appendable a, char quantifier, char weakOrStrong) throws IOException {
        a.append('(');
        a.append(quantifier);
        a.append('(');
        this.getLeftChild().print(a);
        a.append(' ');
        a.append(weakOrStrong);
        a.append(' ');
        this.getRightChild().print(a);
        a.append("))");
    }
}

