/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.transformer;

import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.dd.xdd.XDDManager;
import info.scce.addlib.dd.xdd.latticedd.example.BooleanVector;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.automatalib.modelchecker.m3c.formula.AbstractModalFormulaNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DependencyGraph;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.EquationalBlock;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import net.automatalib.modelchecker.m3c.transformer.DiamondOperation;
import net.automatalib.modelchecker.m3c.transformer.DiamondOperationDeadlock;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ADDTransformer<L, AP>
extends AbstractPropertyTransformer<ADDTransformer<L, AP>, L, AP> {
    private final XDDManager<BooleanVector> xddManager;
    private final @MonotonicNonNull XDD<BooleanVector> add;

    ADDTransformer(XDDManager<BooleanVector> xddManager, XDD<BooleanVector> add) {
        this.xddManager = xddManager;
        this.add = add;
    }

    ADDTransformer(XDDManager<BooleanVector> xddManager, XDD<BooleanVector> add, boolean isMust) {
        super(isMust);
        this.xddManager = xddManager;
        this.add = add;
    }

    public ADDTransformer(XDDManager<BooleanVector> xddManager, DependencyGraph<L, AP> dependGraph) {
        this.xddManager = xddManager;
        boolean[] terminal = new boolean[dependGraph.getNumVariables()];
        for (EquationalBlock<L, AP> block : dependGraph.getBlocks()) {
            if (!block.isMaxBlock()) continue;
            for (FormulaNode<L, AP> node : block.getNodes()) {
                terminal[node.getVarNumber()] = true;
            }
        }
        this.add = xddManager.constant(new BooleanVector(terminal));
    }

    public ADDTransformer(XDDManager<BooleanVector> ddManager) {
        this.xddManager = ddManager;
        this.add = null;
    }

    public <TP extends ModalEdgeProperty> ADDTransformer(XDDManager<BooleanVector> xddManager, L edgeLabel, TP edgeProperty, DependencyGraph<L, AP> dependGraph) {
        XDD<BooleanVector> tmpADD;
        this.xddManager = xddManager;
        ArrayList<XDD<XDD<BooleanVector>>> list = new ArrayList<XDD<XDD<BooleanVector>>>();
        for (FormulaNode<L, AP> node : dependGraph.getFormulaNodes()) {
            boolean[] terminal = new boolean[dependGraph.getNumVariables()];
            XDD<BooleanVector> falseDD = xddManager.constant(new BooleanVector(terminal));
            if (!(node instanceof AbstractModalFormulaNode)) continue;
            AbstractModalFormulaNode modalNode = (AbstractModalFormulaNode)node;
            Object action = modalNode.getAction();
            if (!(action != null && !action.equals(edgeLabel) || modalNode instanceof DiamondNode && !edgeProperty.isMust())) {
                int xj = modalNode.getVarNumberChild();
                boolean[] thenTerminal = new boolean[dependGraph.getNumVariables()];
                thenTerminal[modalNode.getVarNumber()] = true;
                XDD<BooleanVector> thenDD = xddManager.constant(new BooleanVector(thenTerminal));
                XDD<XDD<BooleanVector>> id = xddManager.ithVar(xj, (BooleanVector)((Object)thenDD), (BooleanVector)((Object)falseDD));
                list.add(id);
                continue;
            }
            if (!(modalNode instanceof BoxNode)) continue;
            terminal[modalNode.getVarNumber()] = true;
            list.add(xddManager.constant(new BooleanVector(terminal)));
        }
        if (list.isEmpty()) {
            tmpADD = xddManager.constant(new BooleanVector(new boolean[dependGraph.getNumVariables()]));
        } else {
            tmpADD = (XDD<BooleanVector>)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                tmpADD = tmpADD.apply(BooleanVector::or, (XDD)list.get(i));
            }
        }
        this.add = tmpADD;
    }

    @Override
    public BitSet evaluate(boolean[] input) {
        boolean[] leafData = this.add == null ? input : ((BooleanVector)((XDD)this.add.eval(input)).v()).data();
        BitSet satisfiedVars = new BitSet();
        for (int i = 0; i < leafData.length; ++i) {
            if (!leafData[i]) continue;
            satisfiedVars.set(i);
        }
        return satisfiedVars;
    }

    @Override
    public ADDTransformer<L, AP> compose(ADDTransformer<L, AP> other) {
        if (this.isIdentity() && other.isIdentity()) {
            throw new IllegalStateException("Two identity functions should never be composed");
        }
        XDD<BooleanVector> compAdd = this.isIdentity() ? new XDD<BooleanVector>(other.add.ptr(), this.xddManager) : (other.isIdentity() ? new XDD<BooleanVector>(this.add.ptr(), this.xddManager) : other.add.monadicApply(arg -> {
            boolean[] terminal = (boolean[])arg.data().clone();
            return (BooleanVector)((XDD)this.add.eval(terminal)).v();
        }));
        return new ADDTransformer<L, AP>(this.xddManager, compAdd, this.isMust());
    }

    @Override
    public ADDTransformer<L, AP> createUpdate(Set<AP> atomicPropositions, List<ADDTransformer<L, AP>> compositions, EquationalBlock<L, AP> currentBlock) {
        XDD<BooleanVector> updatedADD;
        DiamondOperation<AP> diamondOp = new DiamondOperation<AP>(atomicPropositions, currentBlock);
        if (compositions.isEmpty()) {
            assert (this.add != null) : "The identity function should never be updated";
            updatedADD = this.add.monadicApply(new DiamondOperationDeadlock<AP>(atomicPropositions, currentBlock));
        } else {
            XDD<BooleanVector> firstAdd = compositions.get((int)0).add;
            assert (firstAdd != null) : "The identity function should never be updated";
            updatedADD = this.preserveUpdatedTransformer(firstAdd, currentBlock);
            for (ADDTransformer<L, AP> composition : compositions) {
                assert (composition.add != null) : "The identity function should never be updated";
                updatedADD = updatedADD.apply(diamondOp, composition.add);
            }
        }
        return new ADDTransformer<L, AP>(this.xddManager, updatedADD);
    }

    private XDD<BooleanVector> preserveUpdatedTransformer(XDD<BooleanVector> rightDD, EquationalBlock<L, AP> currentBlock) {
        assert (this.add != null) : "The identity function should never be updated";
        return this.add.apply((booleanVectorBeforeUpdate, booleanVectorRight) -> {
            boolean[] result = (boolean[])booleanVectorBeforeUpdate.data().clone();
            for (FormulaNode node : currentBlock.getNodes()) {
                result[node.getVarNumber()] = booleanVectorRight.data()[node.getVarNumber()];
            }
            return new BooleanVector(result);
        }, rightDD);
    }

    public @Nullable XDD<BooleanVector> getAdd() {
        return this.add;
    }

    @EnsuresNonNullIf(result=false, expression={"add", "getAdd()"})
    public boolean isIdentity() {
        return this.add == null;
    }

    public int hashCode() {
        return Objects.hashCode(this.add);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADDTransformer that = (ADDTransformer)o;
        return Objects.equals(this.add, that.add);
    }
}

