/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.ModelSerializer;
import net.automatalib.ts.simple.SimpleTS;

public interface InputModelSerializer<I, M extends SimpleTS<?, I>>
extends ModelSerializer<InputModelData<I, M>> {
    public void writeModel(OutputStream var1, M var2, Alphabet<I> var3) throws IOException;

    default public void writeModel(File f, M model, Alphabet<I> alphabet) throws IOException {
        try (OutputStream os = IOUtil.asBufferedOutputStream(f);){
            this.writeModel(os, model, alphabet);
        }
    }

    @Override
    default public void writeModel(OutputStream os, InputModelData<I, M> model) throws IOException {
        this.writeModel(os, model.model, model.alphabet);
    }
}

