/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.learnlibv2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Scanner;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.util.automaton.Automata;

public class LearnLibV2Serialization
implements InputModelSerializationProvider<Integer, DFA<?, Integer>, DFA<Integer, Integer>> {
    private static final LearnLibV2Serialization INSTANCE = new LearnLibV2Serialization();

    public static LearnLibV2Serialization getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeModel(OutputStream os, DFA<?, Integer> model, Alphabet<Integer> alphabet) {
        this.doWriteDFA(model, alphabet, os);
    }

    public <I> void writeGenericModel(OutputStream os, DFA<?, I> model, Alphabet<I> alphabet) {
        this.doWriteDFA(model, alphabet, os);
    }

    @Override
    public InputModelData<Integer, DFA<Integer, Integer>> readModel(InputStream is) throws IOException {
        CompactDFA<Integer> automaton = this.readGenericDFA(is);
        return new InputModelData<Integer, DFA<Integer, Integer>>(automaton, automaton.getInputAlphabet());
    }

    public CompactDFA<Integer> readGenericDFA(InputStream is) throws IOException {
        try (Scanner sc = new Scanner(IOUtil.asUncompressedBufferedNonClosingInputStream(is), StandardCharsets.UTF_8.toString());){
            int i;
            int numStates = sc.nextInt();
            int numSymbols = sc.nextInt();
            Alphabet<Integer> alphabet = Alphabets.integers(0, numSymbols - 1);
            CompactDFA<Integer> result = new CompactDFA<Integer>(alphabet, numStates);
            int[] states = new int[numStates];
            states[0] = result.addIntInitialState(sc.nextInt() != 0);
            for (i = 1; i < numStates; ++i) {
                states[i] = result.addIntState(sc.nextInt() != 0);
            }
            for (i = 0; i < numStates; ++i) {
                int state = states[i];
                for (int j = 0; j < numSymbols; ++j) {
                    int succ = states[sc.nextInt()];
                    result.setTransition(state, j, succ);
                }
            }
            CompactDFA<Integer> compactDFA = result;
            return compactDFA;
        }
    }

    private <S, I> void doWriteDFA(DFA<S, I> dfa, Alphabet<I> alphabet, OutputStream os) {
        int numDfaStates;
        Object initState = dfa.getInitialState();
        if (initState == null) {
            throw new IllegalArgumentException("Serialization format does not support automata without initial state");
        }
        boolean partial = Automata.hasUndefinedInput(dfa, alphabet);
        int numStates = numDfaStates = dfa.size();
        if (partial) {
            ++numStates;
        }
        try (PrintWriter pw = new PrintWriter(IOUtil.asBufferedNonClosingUTF8Writer(os));){
            int numInputs = alphabet.size();
            pw.printf("%d %d%n", numStates, numInputs);
            StateIDs stateIds = dfa.stateIDs();
            int initId = stateIds.getStateId(initState);
            ArrayList orderedStates = new ArrayList(numDfaStates);
            orderedStates.add(initState);
            pw.printf("%d ", dfa.isAccepting(initState) ? 1 : 0);
            for (int i = 1; i < numDfaStates; ++i) {
                Object state = stateIds.getState(i);
                if (i == initId) {
                    state = stateIds.getState(0);
                }
                pw.printf("%d ", dfa.isAccepting(state) ? 1 : 0);
                orderedStates.add(state);
            }
            if (partial) {
                pw.print("0");
            }
            pw.println();
            for (Object state : orderedStates) {
                for (Object sym : alphabet) {
                    Object target = dfa.getSuccessor(state, sym);
                    int targetId = numDfaStates;
                    if (target != null) {
                        targetId = stateIds.getStateId(target);
                        if (targetId == initId) {
                            targetId = 0;
                        } else if (targetId == 0) {
                            targetId = initId;
                        }
                    }
                    pw.printf("%d ", targetId);
                }
                pw.println();
            }
            if (partial) {
                for (int i = 0; i < numInputs; ++i) {
                    pw.printf("%d ", numDfaStates);
                }
                pw.println();
            }
        }
    }
}

