/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.copy;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.common.util.Holder;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.automaton.copy.AbstractLowLevelAutomatonCopier;
import net.automatalib.util.automaton.copy.AutomatonCopyMethod;
import net.automatalib.util.automaton.copy.LowLevelAutomatonCopier;
import net.automatalib.util.traversal.TraversalOrder;
import net.automatalib.util.ts.traversal.TSTraversal;
import net.automatalib.util.ts.traversal.TSTraversalAction;
import net.automatalib.util.ts.traversal.TSTraversalVisitor;

final class TraversalAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2>
extends AbstractLowLevelAutomatonCopier<S1, I1, T1, S2, I2, T2, SP2, TP2, TransitionSystem<S1, ? super I1, T1>>
implements TSTraversalVisitor<S1, I1, T1, S2> {
    private final TraversalOrder traversalOrder;
    private final int limit;

    TraversalAutomatonCopy(TraversalOrder traversalOrder, int limit, TransitionSystem<S1, ? super I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out, Function<? super I1, ? extends I2> inputsMapping, Function<? super S1, ? extends SP2> spMapping, Function<? super T1, ? extends TP2> tpMapping, Predicate<? super S1> stateFilter, TransitionPredicate<? super S1, ? super I1, ? super T1> transFilter) {
        super(in, inputs, out, inputsMapping, spMapping, tpMapping, stateFilter, transFilter);
        this.traversalOrder = traversalOrder;
        this.limit = limit;
    }

    @Override
    public void doCopy() {
        TSTraversal.traverse(this.traversalOrder, this.in, this.limit, this.inputs, this);
    }

    @Override
    public TSTraversalAction processInitial(S1 initialState, Holder<S2> holder) {
        if (this.stateFilter.test(initialState)) {
            holder.value = this.copyInitialState(initialState);
            return TSTraversalAction.EXPLORE;
        }
        return TSTraversalAction.IGNORE;
    }

    @Override
    public TSTraversalAction processTransition(S1 srcState, S2 srcData, I1 input, T1 transition, S1 tgtState, Holder<S2> tgtHolder) {
        if (this.transFilter.apply(srcState, input, transition) && this.stateFilter.test(tgtState)) {
            S2 succ2 = this.copyTransitionChecked(srcData, this.inputsMapping.apply(input), transition, tgtState);
            if (succ2 == null) {
                return TSTraversalAction.IGNORE;
            }
            tgtHolder.value = succ2;
            return TSTraversalAction.EXPLORE;
        }
        return TSTraversalAction.IGNORE;
    }

    static final class CopyMethod
    implements AutomatonCopyMethod {
        private final TraversalOrder traversalOrder;

        CopyMethod(TraversalOrder traversalOrder) {
            this.traversalOrder = traversalOrder;
        }

        @Override
        public <S1, I1, T1, S2, I2, T2, SP2, TP2> LowLevelAutomatonCopier<S1, S2> createLowLevelCopier(Automaton<S1, ? super I1, T1> in, Collection<? extends I1> inputs, MutableAutomaton<S2, I2, T2, ? super SP2, ? super TP2> out, Function<? super I1, ? extends I2> inputsMapping, Function<? super S1, ? extends SP2> spMapping, Function<? super T1, ? extends TP2> tpMapping, Predicate<? super S1> stateFilter, TransitionPredicate<? super S1, ? super I1, ? super T1> transitionFilter) {
            return new TraversalAutomatonCopy<S1, I1, T1, S2, I2, T2, SP2, TP2>(this.traversalOrder, in.size(), in, inputs, out, inputsMapping, spMapping, tpMapping, stateFilter, transitionFilter);
        }
    }
}

