/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.equivalence;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.automatalib.automaton.Automaton;
import net.automatalib.common.util.Pair;

public final class Bisimulation {
    private Bisimulation() {
    }

    public static <AS, I, AT, A extends Automaton<AS, I, AT>, BS, BT, B extends Automaton<BS, I, BT>> Set<Pair<AS, BS>> bisimulationEquivalenceRelation(A a, B b, Collection<I> inputs) {
        HashSet<Object> bisim = Sets.newHashSetWithExpectedSize(a.size() * b.size());
        HashSet<Pair<Object, Object>> change = Sets.newHashSetWithExpectedSize(a.size() * b.size());
        for (Object p : a.getStates()) {
            for (Object q : b.getStates()) {
                boolean empty = true;
                for (I sym : inputs) {
                    empty &= a.getTransitions(p, sym).isEmpty() && b.getTransitions(q, sym).isEmpty();
                    if (a.getTransitions(p, sym).isEmpty() || b.getTransitions(q, sym).isEmpty()) continue;
                    change.add(Pair.of(p, q));
                    break;
                }
                if (!empty) continue;
                change.add(Pair.of(p, q));
            }
        }
        while (!bisim.equals(change)) {
            HashSet<Pair<AS, BS>> swap = change;
            change = bisim;
            bisim = swap;
            change.clear();
            for (Pair pair : bisim) {
                boolean exists;
                boolean forall = true;
                block5: for (I sym : inputs) {
                    for (Object t : a.getTransitions(pair.getFirst(), sym)) {
                        exists = false;
                        for (Object f : b.getTransitions(pair.getSecond(), sym)) {
                            for (Pair pair2 : bisim) {
                                if (!Objects.equals(a.getSuccessor(t), pair2.getFirst()) || !Objects.equals(b.getSuccessor(f), pair2.getSecond())) continue;
                                exists = true;
                                break;
                            }
                            if (!exists) continue;
                            break;
                        }
                        if (exists) continue;
                        forall = false;
                        continue block5;
                    }
                }
                if (!forall) continue;
                block9: for (I sym : inputs) {
                    for (Object f : b.getTransitions(pair.getSecond(), sym)) {
                        exists = false;
                        for (Object t : a.getTransitions(pair.getFirst(), sym)) {
                            for (Pair pair3 : bisim) {
                                if (!Objects.equals(b.getSuccessor(f), pair3.getSecond()) || !Objects.equals(a.getSuccessor(t), pair3.getFirst())) continue;
                                exists = true;
                                break;
                            }
                            if (!exists) continue;
                            break;
                        }
                        if (exists) continue;
                        forall = false;
                        continue block9;
                    }
                }
                if (!forall) continue;
                change.add(pair);
            }
        }
        return change;
    }
}

