/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SBA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.automaton.procedural.StackSPA;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.util.automaton.copy.AutomatonCopyMethod;
import net.automatalib.util.automaton.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automaton.fsa.DFAs;
import net.automatalib.util.automaton.fsa.MutableDFAs;
import net.automatalib.util.automaton.predicate.TransitionPredicates;
import net.automatalib.util.automaton.procedural.ATSequences;
import net.automatalib.util.automaton.procedural.CFMPSViewSBA;
import net.automatalib.util.automaton.procedural.ProceduralUtil;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SBAs {
    private SBAs() {
    }

    public static <I> ATSequences<I> computeATSequences(SBA<?, I> sba) {
        return SBAs.computeATSequences(sba, sba.getInputAlphabet());
    }

    public static <I> ATSequences<I> computeATSequences(SBA<?, I> sba, ProceduralInputAlphabet<I> alphabet) {
        assert (SBAs.isValid(sba, alphabet));
        Map<I, Word<I>> terminatingSequences = SBAs.computeTerminatingSequences(sba, alphabet);
        Map<I, Word<I>> accessSequences = SBAs.computeAccessSequences(sba, alphabet, terminatingSequences);
        return new ATSequences<I>(accessSequences, terminatingSequences);
    }

    public static <I> Map<I, Word<I>> computeTerminatingSequences(SBA<?, I> sba, ProceduralInputAlphabet<I> alphabet) {
        Word returnWord = Word.fromLetter(alphabet.getReturnSymbol());
        return ProceduralUtil.computeTerminatingSequences(sba.getProcedures(), alphabet, (dfa, trace) -> (Boolean)dfa.computeSuffixOutput((Iterable)trace, (Iterable)returnWord));
    }

    public static <I> Map<I, Word<I>> computeAccessSequences(SBA<?, I> sba, ProceduralInputAlphabet<I> alphabet, Map<I, Word<I>> terminatingSequences) {
        return ProceduralUtil.computeAccessSequences(sba.getProcedures(), alphabet, sba.getProceduralInputs(alphabet), sba.getInitialProcedure(), terminatingSequences, DFA::accepts);
    }

    public static <I> boolean isValid(SBA<?, I> sba) {
        return SBAs.isValid(sba, sba.getInputAlphabet());
    }

    public static <I> boolean isValid(SBA<?, I> sba, ProceduralInputAlphabet<I> alphabet) {
        Map<I, Word<I>> ts = SBAs.computeTerminatingSequences(sba, alphabet);
        Collection<I> proceduralInputs = sba.getProceduralInputs(alphabet);
        HashSet nonContinuableSymbols = new HashSet(alphabet.getCallAlphabet());
        nonContinuableSymbols.removeAll(ts.keySet());
        nonContinuableSymbols.retainAll(proceduralInputs);
        nonContinuableSymbols.add(alphabet.getReturnSymbol());
        for (DFA p : sba.getProcedures().values()) {
            if (DFAs.isPrefixClosed(p, proceduralInputs) && SBAs.isCallAndReturnClosed(p, proceduralInputs, nonContinuableSymbols)) continue;
            return false;
        }
        return true;
    }

    private static <S, I> boolean isCallAndReturnClosed(DFA<S, I> procedure, Collection<I> inputs, Collection<I> nonContinuableInputs) {
        for (Object s2 : procedure) {
            for (I i : nonContinuableInputs) {
                Object toAnalyze;
                Object succ = procedure.getSuccessor(s2, i);
                if (succ != null && procedure.isAccepting(succ)) {
                    toAnalyze = procedure.getSuccessor(succ, i);
                    for (I i2 : inputs) {
                        if (Objects.equals(procedure.getSuccessor(succ, i2), toAnalyze)) continue;
                        return false;
                    }
                } else {
                    toAnalyze = succ;
                }
                if (toAnalyze == null || SBAs.isSink(procedure, inputs, toAnalyze)) continue;
                return false;
            }
        }
        return true;
    }

    private static <S, I> boolean isSink(DFA<S, I> dfa, Collection<I> inputs, S state) {
        if (dfa.isAccepting(state)) {
            return false;
        }
        for (I i : inputs) {
            S succ = dfa.getSuccessor(state, i);
            if (succ == null || Objects.equals(succ, state)) continue;
            return false;
        }
        return true;
    }

    public static <I> boolean testEquivalence(SBA<?, I> sba1, SBA<?, I> sba2, ProceduralInputAlphabet<I> alphabet) {
        return SBAs.findSeparatingWord(sba1, sba2, alphabet) == null;
    }

    public static <I> @Nullable Word<I> findSeparatingWord(SBA<?, I> sba1, SBA<?, I> sba2, ProceduralInputAlphabet<I> alphabet) {
        ATSequences<I> at1 = SBAs.computeATSequences(sba1, alphabet);
        ATSequences<I> at2 = SBAs.computeATSequences(sba2, alphabet);
        return ProceduralUtil.findSeparatingWord(sba1.getProcedures(), at1, sba2.getProcedures(), at2, alphabet);
    }

    public static <I> SPA<?, I> reduce(SBA<?, I> sba) {
        return SBAs.reduce(sba, sba.getInputAlphabet());
    }

    public static <I> SPA<?, I> reduce(SBA<?, I> sba, ProceduralInputAlphabet<I> alphabet) {
        Map procedures = sba.getProcedures();
        HashMap spaProcedures = Maps.newHashMapWithExpectedSize(procedures.size());
        Collection<I> proceduralInputs = sba.getProceduralInputs(alphabet);
        proceduralInputs.remove(alphabet.getReturnSymbol());
        for (Map.Entry e : procedures.entrySet()) {
            spaProcedures.put(e.getKey(), SBAs.reduce((DFA)e.getValue(), alphabet, proceduralInputs));
        }
        return new StackSPA(alphabet, sba.getInitialProcedure(), spaProcedures);
    }

    private static <S, I> DFA<?, I> reduce(DFA<S, I> dfa, ProceduralInputAlphabet<I> alphabet, Collection<I> sourceInputs) {
        Object returnSymbol = alphabet.getReturnSymbol();
        Alphabet<I> proceduralAlphabet = alphabet.getProceduralAlphabet();
        Function<Object, Boolean> spMapping = s2 -> {
            Object succ = dfa.getSuccessor(s2, returnSymbol);
            return succ != null && dfa.isAccepting(succ);
        };
        TransitionPredicate transFilter = TransitionPredicates.inputIsNot(returnSymbol);
        CompactDFA<I> result = new CompactDFA<I>(proceduralAlphabet);
        AutomatonLowLevelCopy.rawCopy(AutomatonCopyMethod.BFS, dfa, sourceInputs, result, spMapping, o -> null, o -> true, transFilter);
        MutableDFAs.complete(result, proceduralAlphabet, true);
        return result;
    }

    public static <I> ContextFreeModalProcessSystem<I, Void> toCFMPS(SBA<?, I> sba) {
        assert (SBAs.isValid(sba));
        return new CFMPSViewSBA<I>(sba);
    }
}

